/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class ReadWriteManyEntriesCommand<K, V, R>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 53;
    private Map<? extends K, ? extends V> entries;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;

    public ReadWriteManyEntriesCommand(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.entries = entries;
        this.f = f;
        this.init(componentRegistry);
    }

    public ReadWriteManyEntriesCommand(ReadWriteManyEntriesCommand command) {
        super(command);
        this.entries = command.entries;
        this.f = command.f;
        this.keyDataConversion = command.getKeyDataConversion();
        this.valueDataConversion = command.getValueDataConversion();
    }

    public ReadWriteManyEntriesCommand() {
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    public final ReadWriteManyEntriesCommand<K, V, R> withEntries(Map<? extends K, ? extends V> entries) {
        this.setEntries(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 53;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.entries, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        output.writeObject(this.keyDataConversion);
        output.writeObject(this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.entries = MarshallUtil.unmarshallMap((ObjectInput)input, LinkedHashMap::new);
        this.f = (BiFunction)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = (DataConversion)input.readObject();
        this.valueDataConversion = (DataConversion)input.readObject();
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyEntriesCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList returns = new ArrayList(this.entries.size());
        this.entries.forEach((k, v) -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry == null) {
                throw new IllegalStateException();
            }
            Object decodedValue = this.valueDataConversion.fromStorage(v);
            R r = this.f.apply(decodedValue, EntryViews.readWrite(entry, this.keyDataConversion, this.valueDataConversion));
            returns.add(EntryViews.snapshot(r));
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.entries.keySet();
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteManyEntriesCommand{");
        sb.append("entries=").append(this.entries);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    public Collection<Object> getKeysToLock() {
        return this.entries.keySet();
    }

    @Override
    public Mutation<K, V, ?> toMutation(K key) {
        Object valueFromStorage = this.valueDataConversion.fromStorage(this.entries.get(key));
        return new Mutations.ReadWriteWithValue<K, Object, R>(valueFromStorage, this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }
}

