/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongUnaryOperator;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapLruNode;
import org.infinispan.eviction.EvictionType;
import org.infinispan.metadata.Metadata;

public class BoundedOffHeapDataContainer
extends OffHeapDataContainer {
    private final long maxSize;
    private final Lock lruLock;
    private final LongUnaryOperator sizeCalculator;
    private long currentSize;
    private long firstAddress;
    private long lastAddress;

    public BoundedOffHeapDataContainer(int desiredSize, long maxSize, EvictionType type) {
        super(desiredSize);
        this.maxSize = maxSize;
        this.sizeCalculator = type == EvictionType.COUNT ? i -> 1L : i -> this.offHeapEntryFactory.getSize(i) + (long)OffHeapLruNode.getSize();
        this.lruLock = new ReentrantLock();
        this.firstAddress = 0L;
    }

    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        super.put(key, value, metadata);
        this.ensureSize();
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryReplaced(long newAddress, long oldAddress) {
        long oldSize = this.sizeCalculator.applyAsLong(oldAddress);
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            long lruNode = this.offHeapEntryFactory.getLruNode(oldAddress);
            if (this.trace) {
                this.log.tracef("Replacing LRU node: 0x%016x. OldValue: 0x%016x NewValue: 0x%016x", lruNode, oldAddress, newAddress);
            }
            this.offHeapEntryFactory.setLruNode(newAddress, lruNode);
            OffHeapLruNode.setEntry(lruNode, newAddress);
            this.moveToEnd(lruNode);
            this.currentSize += newSize;
            this.currentSize -= oldSize;
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryReplaced(newAddress, oldAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryCreated(long newAddress) {
        int hashCode = this.offHeapEntryFactory.getHashCode(newAddress);
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            this.currentSize += newSize;
            this.addEntryAddressToEnd(newAddress, hashCode);
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryCreated(newAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryRemoved(long removedAddress) {
        long removedSize = this.sizeCalculator.applyAsLong(removedAddress);
        long lruNode = this.offHeapEntryFactory.getLruNode(removedAddress);
        assert (lruNode != 0L);
        this.lruLock.lock();
        try {
            long previousLRUNode;
            this.currentSize -= removedSize;
            boolean middleNode = true;
            if (lruNode == this.lastAddress) {
                if (this.trace) {
                    this.log.tracef("Removing last LRU node at 0x%016x", lruNode);
                }
                if ((previousLRUNode = OffHeapLruNode.getPrevious(lruNode)) != 0L) {
                    OffHeapLruNode.setNext(previousLRUNode, 0L);
                }
                this.lastAddress = previousLRUNode;
                middleNode = false;
            }
            if (lruNode == this.firstAddress) {
                long nextLRUNode;
                if (this.trace) {
                    this.log.tracef("Removing first LRU node at 0x%016x", lruNode);
                }
                if ((nextLRUNode = OffHeapLruNode.getNext(lruNode)) != 0L) {
                    OffHeapLruNode.setPrevious(nextLRUNode, 0L);
                }
                this.firstAddress = nextLRUNode;
                middleNode = false;
            }
            if (middleNode) {
                if (this.trace) {
                    this.log.tracef("Removing middle LRU node at 0x%016x", lruNode);
                }
                previousLRUNode = OffHeapLruNode.getPrevious(lruNode);
                long nextLRUNode = OffHeapLruNode.getNext(lruNode);
                assert (previousLRUNode != 0L);
                assert (nextLRUNode != 0L);
                OffHeapLruNode.setNext(previousLRUNode, nextLRUNode);
                OffHeapLruNode.setPrevious(nextLRUNode, previousLRUNode);
            }
            this.allocator.deallocate(lruNode, OffHeapLruNode.getSize());
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryRemoved(removedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryRetrieved(long entryAddress) {
        this.lruLock.lock();
        try {
            long lruNode = this.offHeapEntryFactory.getLruNode(entryAddress);
            if (this.trace) {
                this.log.tracef("Moving lruNode 0x%016x to the end which points at address 0x%016x", lruNode, entryAddress);
            }
            this.moveToEnd(lruNode);
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryRetrieved(entryAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performClear() {
        if (this.trace) {
            this.log.trace("Clearing bounded LRU entries");
        }
        this.lruLock.lock();
        try {
            long address = this.firstAddress;
            while (address != 0L) {
                long nextAddress = OffHeapLruNode.getNext(address);
                this.allocator.deallocate(address, OffHeapLruNode.getSize());
                address = nextAddress;
            }
            this.currentSize = 0L;
            this.firstAddress = 0L;
            this.lastAddress = 0L;
        }
        finally {
            this.lruLock.unlock();
        }
        if (this.trace) {
            this.log.trace("Cleared bounded LRU entries");
        }
        super.performClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureSize() {
        while (true) {
            long addressToRemove;
            Lock entryWriteLock;
            int hashCode;
            this.lruLock.lock();
            try {
                if (this.currentSize <= this.maxSize) return;
                hashCode = OffHeapLruNode.getHashCode(this.firstAddress);
                entryWriteLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                addressToRemove = !entryWriteLock.tryLock() ? 0L : OffHeapLruNode.getEntry(this.firstAddress);
            }
            finally {
                this.lruLock.unlock();
            }
            if (addressToRemove == 0L) {
                entryWriteLock.lock();
                try {
                    this.lruLock.lock();
                    try {
                        if (this.currentSize <= this.maxSize) return;
                        hashCode = OffHeapLruNode.getHashCode(this.firstAddress);
                        Lock innerLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                        addressToRemove = innerLock == entryWriteLock ? OffHeapLruNode.getEntry(this.firstAddress) : 0L;
                    }
                    finally {
                        this.lruLock.unlock();
                    }
                }
                finally {
                    if (addressToRemove == 0L) {
                        entryWriteLock.unlock();
                    }
                }
            }
            if (addressToRemove == 0L) continue;
            if (this.trace) {
                this.log.tracef("Removing entry: 0x%016x due to eviction due to size %d being larger than maximum of %d", addressToRemove, this.currentSize, this.maxSize);
            }
            try {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(addressToRemove);
                this.passivator.passivate(ice);
                this.performRemove(addressToRemove, ice.getKey());
                this.evictionManager.onEntryEviction(Collections.singletonMap(ice.getKey(), ice));
                continue;
            }
            finally {
                entryWriteLock.unlock();
                continue;
            }
            break;
        }
    }

    private void addEntryAddressToEnd(long entryAddress, int hashCode) {
        long nodeAddress = this.allocator.allocate(OffHeapLruNode.getSize());
        if (this.trace) {
            this.log.tracef("Creating LRU node 0x%016x for new entry 0x%016x", nodeAddress, entryAddress);
        }
        OffHeapLruNode.setEntry(nodeAddress, entryAddress);
        this.offHeapEntryFactory.setLruNode(entryAddress, nodeAddress);
        if (this.lastAddress == 0L) {
            this.firstAddress = nodeAddress;
            this.lastAddress = nodeAddress;
            OffHeapLruNode.setPrevious(nodeAddress, 0L);
        } else {
            OffHeapLruNode.setPrevious(nodeAddress, this.lastAddress);
            OffHeapLruNode.setNext(this.lastAddress, nodeAddress);
            this.lastAddress = nodeAddress;
        }
        OffHeapLruNode.setNext(nodeAddress, 0L);
        OffHeapLruNode.setHashCode(nodeAddress, hashCode);
    }

    private void moveToEnd(long lruNode) {
        if (lruNode != this.lastAddress) {
            long nextLruNode = OffHeapLruNode.getNext(lruNode);
            if (lruNode == this.firstAddress) {
                OffHeapLruNode.setPrevious(nextLruNode, 0L);
                this.firstAddress = nextLruNode;
            } else {
                long prevLruNode = OffHeapLruNode.getPrevious(lruNode);
                OffHeapLruNode.setNext(prevLruNode, nextLruNode);
                OffHeapLruNode.setPrevious(nextLruNode, prevLruNode);
            }
            OffHeapLruNode.setNext(this.lastAddress, lruNode);
            OffHeapLruNode.setPrevious(lruNode, this.lastAddress);
            OffHeapLruNode.setNext(lruNode, 0L);
            this.lastAddress = lruNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> debugLruList() {
        if (this.firstAddress == 0L) {
            return Collections.emptyList();
        }
        this.lruLock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>(this.sizeIncludingExpired());
            long a = this.firstAddress;
            while (a != 0L) {
                long n = OffHeapLruNode.getNext(a);
                list.add(OffHeapLruNode.debugString(a));
                assert (n == 0L || OffHeapLruNode.getPrevious(n) == a);
                a = OffHeapLruNode.getNext(a);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.lruLock.unlock();
        }
    }
}

