/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.JmxAttributeMetadata;
import org.infinispan.factories.components.JmxOperationMetadata;
import org.infinispan.jmx.annotations.MBean;

public class ManageableComponentMetadata
extends ComponentMetadata {
    private String jmxObjectName;
    private String description;
    private Set<JmxAttributeMetadata> attributeMetadata;
    private Set<JmxOperationMetadata> operationMetadata;

    public ManageableComponentMetadata(Class<?> component, List<Method> injectMethods, List<Method> startMethods, List<Method> postStartMethods, List<Method> stopMethods, boolean global, boolean survivesRestarts, List<Field> managedAttributeFields, List<Method> managedAttributeMethods, List<Method> managedOperationMethods, MBean mbean) {
        super(component, injectMethods, startMethods, postStartMethods, stopMethods, global, survivesRestarts);
        if (managedAttributeFields != null && !managedAttributeFields.isEmpty() || managedAttributeMethods != null && !managedAttributeMethods.isEmpty()) {
            this.attributeMetadata = new HashSet<JmxAttributeMetadata>((managedAttributeFields == null ? 0 : managedAttributeFields.size()) + (managedAttributeMethods == null ? 0 : managedAttributeMethods.size()));
            if (managedAttributeFields != null) {
                for (Field f : managedAttributeFields) {
                    this.attributeMetadata.add(new JmxAttributeMetadata(f));
                }
            }
            if (managedAttributeMethods != null) {
                for (Method m : managedAttributeMethods) {
                    this.attributeMetadata.add(new JmxAttributeMetadata(m));
                }
            }
        }
        if (managedOperationMethods != null && !managedOperationMethods.isEmpty()) {
            this.operationMetadata = new HashSet<JmxOperationMetadata>(managedOperationMethods.size());
            for (Method m : managedOperationMethods) {
                this.operationMetadata.add(new JmxOperationMetadata(m));
            }
        }
        this.jmxObjectName = mbean.objectName();
        this.description = mbean.description();
    }

    public String getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<JmxAttributeMetadata> getAttributeMetadata() {
        if (this.attributeMetadata == null) {
            return Collections.emptySet();
        }
        return this.attributeMetadata;
    }

    public Set<JmxOperationMetadata> getOperationMetadata() {
        if (this.operationMetadata == null) {
            return Collections.emptySet();
        }
        return this.operationMetadata;
    }

    @Override
    public boolean isManageable() {
        return true;
    }

    @Override
    public ManageableComponentMetadata toManageableComponentMetadata() {
        return this;
    }

    @Override
    public String toString() {
        return "ManageableComponentMetadata{jmxObjectName='" + this.jmxObjectName + '\'' + ", description='" + this.description + '\'' + ", attributeMetadata=" + this.attributeMetadata + ", operationMetadata=" + this.operationMetadata + '}';
    }
}

