/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.concurrent.locks.LockManager;

public abstract class ClusteringInterceptor
extends BaseRpcInterceptor {
    protected CommandsFactory cf;
    protected EntryFactory entryFactory;
    protected LockManager lockManager;
    protected DataContainer dataContainer;
    protected StateTransferManager stateTransferManager;

    protected static Response getSingleResponse(Map<Address, Response> responseMap) {
        Iterator<Response> it = responseMap.values().iterator();
        if (!it.hasNext()) {
            throw AllOwnersLostException.INSTANCE;
        }
        Response response = it.next();
        if (it.hasNext()) {
            throw new IllegalStateException("Too many responses " + responseMap);
        }
        return response;
    }

    protected static SuccessfulResponse getSuccessfulResponseOrFail(Map<Address, Response> responseMap, CompletableFuture<?> future, Consumer<Response> cacheNotFound) {
        Iterator<Response> it = responseMap.values().iterator();
        if (!it.hasNext()) {
            future.completeExceptionally((Throwable)((Object)AllOwnersLostException.INSTANCE));
            return null;
        }
        Response response = it.next();
        if (it.hasNext()) {
            future.completeExceptionally(new IllegalStateException("Too many responses " + responseMap));
        } else {
            if (response instanceof SuccessfulResponse) {
                return (SuccessfulResponse)response;
            }
            if (response instanceof CacheNotFoundResponse || response instanceof UnsureResponse) {
                if (cacheNotFound == null) {
                    future.completeExceptionally(ClusteringInterceptor.unexpected(response));
                } else {
                    try {
                        cacheNotFound.accept(response);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            } else {
                future.completeExceptionally(ClusteringInterceptor.unexpected(response));
            }
        }
        return null;
    }

    protected static IllegalArgumentException unexpected(Response response) {
        return new IllegalArgumentException("Unexpected response " + response);
    }

    @Inject
    public void injectDependencies(CommandsFactory cf, EntryFactory entryFactory, LockManager lockManager, DataContainer dataContainer, StateTransferManager stateTransferManager) {
        this.cf = cf;
        this.entryFactory = entryFactory;
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.stateTransferManager = stateTransferManager;
    }

    protected class ClusteredGetAllFuture
    extends CompletableFuture<Void> {
        public int counter;

        public ClusteredGetAllFuture(int counter) {
            this.counter = counter;
        }

        @Override
        public synchronized boolean completeExceptionally(Throwable ex) {
            return super.completeExceptionally(ex);
        }
    }
}

