/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.stream.impl.EndIterator;
import org.infinispan.stream.impl.IteratorResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class IteratorResponses
implements IteratorResponse {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Iterator<Object> iterator;

    IteratorResponses(Iterator<Object> iterator) {
        this.iterator = iterator;
    }

    public Iterator<Object> getIterator() {
        return this.iterator;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    public static class IteratorResponsesExternalizer
    extends AbstractExternalizer<IteratorResponses> {
        public Integer getId() {
            return 111;
        }

        public Set<Class<? extends IteratorResponses>> getTypeClasses() {
            return Collections.singleton(RemoteResponse.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeObject(ObjectOutput output, IteratorResponses object) throws IOException {
            long i;
            RemoteResponse resp = (RemoteResponse)object;
            Iterator<Object> iter = resp.getIterator();
            for (i = 0L; i < resp.batchSize && iter.hasNext(); ++i) {
                output.writeObject(iter.next());
            }
            output.writeObject(EndIterator.getInstance());
            boolean completed = !iter.hasNext();
            log.tracef("Sending %s entries to requestor and was complete? %s", String.valueOf(i), completed);
            output.writeBoolean(completed);
            if (completed) {
                Set<Integer> segments;
                Set<Integer> set = segments = resp.getSuspectedSegments();
                synchronized (set) {
                    output.writeObject(segments);
                }
            }
        }

        public IteratorResponses readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Iterator<Object> iterator;
            Object object = input.readObject();
            if (object != EndIterator.getInstance()) {
                Stream.Builder<Object> builder = Stream.builder();
                builder.accept(object);
                while ((object = input.readObject()) != EndIterator.getInstance()) {
                    builder.accept(object);
                }
                iterator = builder.build().iterator();
            } else {
                iterator = Collections.emptyIterator();
            }
            boolean complete = input.readBoolean();
            if (complete) {
                return new LastResponse(iterator, (Set)input.readObject());
            }
            return new BatchResponse(iterator);
        }
    }

    private static class LastResponse
    extends IteratorResponses {
        private final Set<Integer> suspectedSegments;

        LastResponse(Iterator<Object> iterator, Set<Integer> suspectedSegments) {
            super(iterator);
            this.suspectedSegments = suspectedSegments;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public Set<Integer> getSuspectedSegments() {
            return this.suspectedSegments;
        }

        public String toString() {
            return "LastResponse {suspectedSegments=" + this.suspectedSegments + "}";
        }
    }

    private static class BatchResponse
    extends IteratorResponses {
        BatchResponse(Iterator<Object> iterator) {
            super(iterator);
        }

        @Override
        public Set<Integer> getSuspectedSegments() {
            return Collections.emptySet();
        }

        public String toString() {
            return "BatchResponse - more values required";
        }
    }

    static class RemoteResponse
    extends IteratorResponses {
        private final Set<Integer> suspectedSegments;
        private final long batchSize;

        RemoteResponse(Iterator<Object> iterator, Set<Integer> suspectedSegments, long batchSize) {
            super(iterator);
            this.suspectedSegments = suspectedSegments;
            this.batchSize = batchSize;
        }

        @Override
        public Set<Integer> getSuspectedSegments() {
            return this.suspectedSegments;
        }
    }
}

