/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stream.impl.IteratorHandler;
import org.infinispan.stream.impl.IteratorResponse;
import org.infinispan.stream.impl.IteratorResponses;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.SegmentAwareOperation;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener(observation=Listener.Observation.POST)
public class LocalStreamManagerImpl<K, V>
implements LocalStreamManager<K> {
    private static final Log log = LogFactory.getLog(LocalStreamManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private AdvancedCache<K, V> cache;
    private ComponentRegistry registry;
    private StateTransferManager stm;
    private RpcManager rpc;
    private CommandsFactory factory;
    private boolean hasLoader;
    private IteratorHandler iteratorHandler;
    private Address localAddress;
    private CacheMode cacheMode;
    private final ConcurrentMap<Object, SegmentListener> changeListener = CollectionFactory.makeConcurrentMap();
    private ByteString cacheName;

    @Inject
    public void inject(Cache<K, V> cache, ComponentRegistry registry, StateTransferManager stm, RpcManager rpc, Configuration configuration, CommandsFactory factory, IteratorHandler iterationHandler) {
        this.cache = AbstractDelegatingCache.unwrapCache(cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
        this.cacheName = ByteString.fromString(cache.getName());
        this.registry = registry;
        this.stm = stm;
        this.rpc = rpc;
        this.factory = factory;
        this.hasLoader = configuration.persistence().usingStores();
        this.iteratorHandler = iterationHandler;
    }

    @Start
    public void start() {
        this.localAddress = this.rpc.getAddress();
        this.cache.addListener(this);
        this.cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<K, V> event) {
        ConsistentHash startHash = event.getConsistentHashAtStart();
        ConsistentHash endHash = event.getConsistentHashAtEnd();
        boolean trace = log.isTraceEnabled();
        if (startHash != null && endHash != null) {
            if (trace) {
                log.tracef("Data rehash occurred startHash: %s and endHash: %s with new topology %s and was pre %s", new Object[]{startHash, endHash, event.getNewTopologyId(), event.isPre()});
            }
            if (!this.changeListener.isEmpty()) {
                if (trace) {
                    log.tracef("Previous segments %s ", startHash.getSegmentsForOwner(this.localAddress));
                    log.tracef("After segments %s ", endHash.getSegmentsForOwner(this.localAddress));
                }
                HashSet<Integer> beforeSegments = new HashSet<Integer>(startHash.getSegmentsForOwner(this.localAddress));
                beforeSegments.removeAll(endHash.getSegmentsForOwner(this.localAddress));
                if (!beforeSegments.isEmpty()) {
                    for (Map.Entry entry : this.changeListener.entrySet()) {
                        if (trace) {
                            log.tracef("Notifying %s through SegmentChangeListener", entry.getKey());
                        }
                        ((SegmentListener)entry.getValue()).lostSegments(beforeSegments);
                    }
                } else if (trace) {
                    log.tracef("No segments have been removed from data rehash, no notification required", new Object[0]);
                }
            } else if (trace) {
                log.tracef("No change listeners present!", new Object[0]);
            }
        }
    }

    private AdvancedCache<K, V> getCacheRespectingLoader(boolean includeLoader) {
        if (this.hasLoader && !includeLoader) {
            return this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        }
        return this.cache;
    }

    private Stream<CacheEntry<K, V>> getStream(CacheSet<CacheEntry<K, V>> cacheEntrySet, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude) {
        BaseStream stream = (parallelStream ? cacheEntrySet.parallelStream() : cacheEntrySet.stream()).filterKeys(keysToInclude).filterKeySegments((Set)segments);
        if (this.cacheMode.isScattered()) {
            stream = stream.filter(entry -> entry.getValue() != null);
        }
        if (!keysToExclude.isEmpty()) {
            log.warn("Added exclude filter");
            return stream.filter(e -> !keysToExclude.contains(e.getKey()));
        }
        return stream;
    }

    private Stream<CacheEntry<K, V>> getRehashStream(CacheSet<CacheEntry<K, V>> cacheEntrySet, Object requestId, SegmentListener listener, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude) {
        CacheTopology topology = this.stm.getCacheTopology();
        if (trace) {
            log.tracef("Topology for supplier is %s for id %s", topology, requestId);
        }
        ConsistentHash readCH = topology.getCurrentCH();
        ConsistentHash pendingCH = topology.getPendingCH();
        if (pendingCH != null) {
            HashSet<Integer> lostSegments = new HashSet<Integer>();
            Iterator<Integer> iterator = segments.iterator();
            while (iterator.hasNext()) {
                Integer segment = iterator.next();
                int intSegment = segment;
                if (pendingCH.locateOwnersForSegment(intSegment).contains(this.localAddress) && readCH.locateOwnersForSegment(intSegment).contains(this.localAddress)) continue;
                iterator.remove();
                lostSegments.add(segment);
            }
            if (!lostSegments.isEmpty()) {
                if (trace) {
                    log.tracef("Lost segments %s during rehash for id %s", lostSegments, requestId);
                }
                listener.lostSegments(lostSegments);
            } else if (trace) {
                log.tracef("Currently in the middle of a rehash for id %s", requestId);
            }
        } else {
            Set<Integer> ourSegments = readCH.getSegmentsForOwner(this.localAddress);
            if (segments.retainAll(ourSegments)) {
                if (trace) {
                    log.tracef("We found to be missing some segments requested for id %s", requestId);
                }
                listener.localSegments(ourSegments);
            } else if (trace) {
                log.tracef("Hash %s for id %s", readCH, requestId);
            }
        }
        return this.getStream(cacheEntrySet, parallelStream, segments, keysToInclude, keysToExclude);
    }

    private void handleResponseError(CompletableFuture<Map<Address, Response>> completableFuture, Object requestId, Address origin) {
        if (trace) {
            completableFuture.whenComplete((v, e) -> {
                if (v != null) {
                    Response response = (Response)v.values().iterator().next();
                    if (!response.isSuccessful()) {
                        log.tracef("Unsuccessful response for %s sending response to %s", requestId, origin);
                    }
                } else if (e != null) {
                    log.tracef((Throwable)e, "Encounted exception for %s sending response to %s", requestId, origin);
                } else {
                    log.tracef("Response successfully sent for %s", requestId);
                }
            });
        }
    }

    @Override
    public <R> void streamOperation(Object requestId, Address origin, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, TerminalOperation<R> operation) {
        if (trace) {
            log.tracef("Received operation request for id %s from %s for segments %s", requestId, origin, segments);
        }
        CacheSet<CacheEntry<K, V>> cacheEntrySet = this.getCacheRespectingLoader(includeLoader).cacheEntrySet();
        operation.setSupplier(() -> this.getStream(cacheEntrySet, parallelStream, segments, keysToInclude, keysToExclude));
        operation.handleInjection(this.registry);
        R value = operation.performOperation();
        CompletableFuture<Map<Address, Response>> completableFuture = this.rpc.invokeRemotelyAsync(Collections.singleton(origin), this.factory.buildStreamResponseCommand(requestId, true, Collections.emptySet(), value), this.rpc.getDefaultRpcOptions(true));
        this.handleResponseError(completableFuture, requestId, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void streamOperationRehashAware(Object requestId, Address origin, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, TerminalOperation<R> operation) {
        R value;
        if (trace) {
            log.tracef("Received rehash aware operation request for id %s from %s for segments %s", requestId, origin, segments);
        }
        CacheSet<CacheEntry<K, V>> cacheEntrySet = this.getCacheRespectingLoader(includeLoader).cacheEntrySet();
        SegmentListener listener = new SegmentListener(segments, operation);
        operation.handleInjection(this.registry);
        this.changeListener.put(requestId, listener);
        if (trace) {
            log.tracef("Registered change listener for %s", requestId);
        }
        try {
            operation.setSupplier(() -> this.getRehashStream(cacheEntrySet, requestId, listener, parallelStream, segments, keysToInclude, keysToExclude));
            value = operation.performOperation();
            if (trace) {
                log.tracef("Request %s completed for segments %s with %s suspected segments", requestId, segments, listener.segmentsLost);
            }
        }
        finally {
            this.changeListener.remove(requestId);
            if (trace) {
                log.tracef("UnRegistered change listener for %s", requestId);
            }
        }
        if (this.cache.getStatus() != ComponentStatus.RUNNING) {
            if (trace) {
                log.tracef("Cache status is no longer running, all segments are now suspect for %s", requestId);
            }
            listener.segmentsLost.addAll(segments);
            value = null;
        }
        if (trace) {
            log.tracef("Sending response for %s", requestId);
        }
        CompletableFuture<Map<Address, Response>> completableFuture = this.rpc.invokeRemotelyAsync(Collections.singleton(origin), this.factory.buildStreamResponseCommand(requestId, true, listener.segmentsLost, value), this.rpc.getDefaultRpcOptions(true));
        this.handleResponseError(completableFuture, requestId, origin);
    }

    @Override
    public <R> void streamOperation(Object requestId, Address origin, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, R, ?> operation) {
        if (trace) {
            log.tracef("Received key aware operation request for id %s from %s for segments %s", requestId, origin, segments);
        }
        CacheSet<CacheEntry<K, V>> cacheEntrySet = this.getCacheRespectingLoader(includeLoader).cacheEntrySet();
        operation.setSupplier(() -> this.getStream(cacheEntrySet, parallelStream, segments, keysToInclude, keysToExclude));
        operation.handleInjection(this.registry);
        Collection<R> value = operation.performOperation(new NonRehashIntermediateCollector(origin, requestId, parallelStream));
        CompletableFuture<Map<Address, Response>> completableFuture = this.rpc.invokeRemotelyAsync(Collections.singleton(origin), this.factory.buildStreamResponseCommand(requestId, true, Collections.emptySet(), value), this.rpc.getDefaultRpcOptions(true));
        this.handleResponseError(completableFuture, requestId, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R2> void streamOperationRehashAware(Object requestId, Address origin, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, ?, R2> operation) {
        Collection<CacheEntry<K, R2>> results;
        if (trace) {
            log.tracef("Received key rehash aware operation request for id %s from %s for segments %s", requestId, origin, segments);
        }
        CacheSet<CacheEntry<K, V>> cacheEntrySet = this.getCacheRespectingLoader(includeLoader).cacheEntrySet();
        SegmentListener listener = new SegmentListener(segments, operation);
        operation.handleInjection(this.registry);
        this.changeListener.put(requestId, listener);
        if (trace) {
            log.tracef("Registered change listener for %s", requestId);
        }
        try {
            operation.setSupplier(() -> this.getRehashStream(cacheEntrySet, requestId, listener, parallelStream, segments, keysToInclude, keysToExclude));
            results = operation.performOperationRehashAware(new NonRehashIntermediateCollector(origin, requestId, parallelStream));
            if (trace) {
                log.tracef("Request %s completed segments %s with %s suspected segments", requestId, segments, listener.segmentsLost);
            }
        }
        finally {
            this.changeListener.remove(requestId);
            if (trace) {
                log.tracef("UnRegistered change listener for %s", requestId);
            }
        }
        if (this.cache.getStatus() != ComponentStatus.RUNNING) {
            if (trace) {
                log.tracef("Cache status is no longer running, all segments are now suspect for %s", requestId);
            }
            listener.segmentsLost.addAll(segments);
            results = null;
        }
        CompletableFuture<Map<Address, Response>> completableFuture = this.rpc.invokeRemotelyAsync(Collections.singleton(origin), this.factory.buildStreamResponseCommand(requestId, true, listener.segmentsLost, results), this.rpc.getDefaultRpcOptions(true));
        this.handleResponseError(completableFuture, requestId, origin);
    }

    @Override
    public IteratorResponse startIterator(Object requestId, Address origin, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, Iterable<IntermediateOperation> intermediateOperations, long batchSize) {
        if (trace) {
            log.tracef("Received rehash aware operation request to start iterator for id %s from %s for segments %s", requestId, origin, segments);
        }
        CacheSet<CacheEntry<K, V>> cacheEntrySet = this.getCacheRespectingLoader(includeLoader).cacheEntrySet();
        SegmentListener listener = new SegmentListener((Set<Integer>)segments, i -> true);
        if (this.changeListener.putIfAbsent(requestId, listener) != null) {
            throw new IllegalStateException("Iterator was already created for id " + requestId);
        }
        if (trace) {
            log.tracef("Registered change listener for %s", requestId);
        }
        IteratorHandler.OnCloseIterator iterator = this.iteratorHandler.start(origin, () -> this.getRehashStream(cacheEntrySet, requestId, listener, false, (Set<Integer>)segments, keysToInclude, keysToExclude), intermediateOperations, requestId);
        iterator.onClose(() -> {
            this.changeListener.remove(requestId);
            if (this.cache.getStatus() != ComponentStatus.RUNNING) {
                if (trace) {
                    log.tracef("Cache status is no longer running after completing iterator, all segments are now suspect for %s", requestId);
                }
                listener.segmentsLost.addAll(segments);
            }
        });
        return new IteratorResponses.RemoteResponse((Iterator<Object>)((Object)iterator), listener.segmentsLost, batchSize);
    }

    @Override
    public IteratorResponse continueIterator(Object requestId, long batchSize) {
        CloseableIterator iterator = this.iteratorHandler.getIterator(requestId);
        return new IteratorResponses.RemoteResponse((Iterator<Object>)iterator, ((SegmentListener)this.changeListener.get(requestId)).segmentsLost, batchSize);
    }

    class NonRehashIntermediateCollector<R>
    implements KeyTrackingTerminalOperation.IntermediateCollector<R> {
        private final Address origin;
        private final Object requestId;
        private final boolean useManagedBlocker;

        NonRehashIntermediateCollector(Address origin, Object requestId, boolean useManagedBlocker) {
            this.origin = origin;
            this.requestId = requestId;
            this.useManagedBlocker = useManagedBlocker;
        }

        @Override
        public void sendDataResonse(R response) {
            if (this.useManagedBlocker) {
                try {
                    ForkJoinPool.managedBlock(new ResponseBlocker(response));
                }
                catch (InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
            } else {
                LocalStreamManagerImpl.this.rpc.invokeRemotely(Collections.singleton(this.origin), new StreamResponseCommand<R>(LocalStreamManagerImpl.this.cacheName, LocalStreamManagerImpl.this.localAddress, this.requestId, false, response), LocalStreamManagerImpl.this.rpc.getDefaultRpcOptions(true));
            }
        }

        class ResponseBlocker
        implements ForkJoinPool.ManagedBlocker {
            private final R response;
            private boolean completed = false;

            ResponseBlocker(R response) {
                this.response = response;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean block() throws InterruptedException {
                if (!this.completed) {
                    NonRehashIntermediateCollector nonRehashIntermediateCollector = NonRehashIntermediateCollector.this;
                    synchronized (nonRehashIntermediateCollector) {
                        LocalStreamManagerImpl.this.rpc.invokeRemotely(Collections.singleton(NonRehashIntermediateCollector.this.origin), new StreamResponseCommand(LocalStreamManagerImpl.this.cacheName, LocalStreamManagerImpl.this.localAddress, NonRehashIntermediateCollector.this.requestId, false, this.response), LocalStreamManagerImpl.this.rpc.getDefaultRpcOptions(true));
                    }
                }
                this.completed = true;
                return this.completed;
            }

            @Override
            public boolean isReleasable() {
                return this.completed;
            }
        }
    }

    class SegmentListener {
        private final Set<Integer> segments;
        private final SegmentAwareOperation op;
        private final Set<Integer> segmentsLost;

        SegmentListener(Set<Integer> segments, SegmentAwareOperation op) {
            this.segments = new HashSet<Integer>(segments);
            this.op = op;
            this.segmentsLost = Collections.synchronizedSet(new HashSet());
        }

        public void localSegments(Set<Integer> localSegments) {
            this.segments.forEach(s -> {
                if (!localSegments.contains(s)) {
                    if (trace) {
                        log.tracef("Could not process segment %s", s);
                    }
                    this.segmentsLost.add((Integer)s);
                }
            });
        }

        public void lostSegments(Set<Integer> lostSegments) {
            for (Integer segment : lostSegments) {
                if (!this.segments.contains(segment)) continue;
                if (trace) {
                    log.tracef("Lost segment %s", segment);
                }
                if (!this.op.lostSegment(false) || !this.segmentsLost.add(segment) || this.segmentsLost.size() != this.segments.size()) continue;
                if (trace) {
                    log.tracef("All segments %s are now lost", this.segments);
                }
                this.op.lostSegment(true);
            }
        }
    }
}

