/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.IteratorHandler;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class StreamIteratorCloseCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 72;
    protected IteratorHandler handler;
    protected Object id;

    public Object getId() {
        return this.id;
    }

    private StreamIteratorCloseCommand() {
        super(null);
    }

    public StreamIteratorCloseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamIteratorCloseCommand(ByteString cacheName, Address origin, Object id) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
    }

    @Inject
    public void inject(IteratorHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.handler.closeIterator(this.getOrigin(), this.id);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 72;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.id);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

