/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;

class SplitArrayParameterValueTransformer
implements ParameterValueTransformer {
    private final String separatorPattern;
    private final ParameterValueTransformer itemTransformer;

    public SplitArrayParameterValueTransformer(String separatorPattern, ParameterValueTransformer itemTransformer) {
        this.separatorPattern = separatorPattern;
        this.itemTransformer = itemTransformer;
    }

    @Override
    public JsonElement transform(String parameterValue) {
        JsonArray array = new JsonArray();
        for (String stringItem : parameterValue.split(this.separatorPattern)) {
            array.add(this.itemTransformer.transform(stringItem));
        }
        return array;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.separatorPattern + "," + this.itemTransformer + "]";
    }
}

