/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.TranscodingUtils;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class TextTranscoder
implements Transcoder {
    private static final Log log = LogFactory.getLog(TextTranscoder.class);
    public static final TextTranscoder INSTANCE = new TextTranscoder();
    private final Set<MediaType> supported = new HashSet<MediaType>();

    public TextTranscoder() {
        this.supported.add(MediaType.TEXT_PLAIN);
        this.supported.add(MediaType.APPLICATION_JSON);
        this.supported.add(MediaType.APPLICATION_XML);
    }

    @Override
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        Optional<String> optDestinationCharset = destinationType.getParameter("charset");
        if (!optDestinationCharset.isPresent()) {
            return content;
        }
        if (content instanceof byte[]) {
            Charset sourceCharset = contentType.getParameter("charset").map(Charset::forName).orElse(Charset.defaultCharset());
            Charset destinationCharset = Charset.forName(optDestinationCharset.get());
            byte[] byteContent = (byte[])content;
            return TranscodingUtils.convertCharset(byteContent, sourceCharset, destinationCharset);
        }
        throw log.unsupportedContent(content);
    }

    @Override
    public Set<MediaType> getSupportedMediaTypes() {
        return this.supported;
    }

    @Override
    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        if (mediaType.match(other)) {
            return this.supported.stream().anyMatch(m -> m.match(mediaType));
        }
        return mediaType.match(MediaType.TEXT_PLAIN) && this.supported.stream().anyMatch(m -> m.match(other)) || other.match(MediaType.TEXT_PLAIN) && this.supported.stream().anyMatch(m -> m.match(mediaType));
    }
}

