/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CriteriaObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make();
    private static final int MAX_IN_CLAUSE = 500;
    public static final CriteriaObjectInitializer INSTANCE = new CriteriaObjectInitializer();

    private CriteriaObjectInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        int maxResults = entityInfos.length;
        if (log.isTraceEnabled()) {
            log.tracef("Load %d objects using criteria queries", maxResults);
        }
        if (maxResults == 0) {
            return;
        }
        List<Criteria> criterias = this.buildUpCriteria(entityInfos, objectInitializationContext);
        for (Criteria criteria : criterias) {
            this.setCriteriaTimeout(criteria, objectInitializationContext.getTimeoutManager());
            List queryResultList = criteria.list();
            InstanceInitializer instanceInitializer = objectInitializationContext.getExtendedSearchIntegrator().getInstanceInitializer();
            for (Object o : queryResultList) {
                XMember idProperty;
                Object id;
                EntityInfoLoadKey key;
                Object previousValue;
                Class loadedType = instanceInitializer.getClass(o);
                Object unproxiedObject = instanceInitializer.unproxy(o);
                DocumentBuilderIndexedEntity documentBuilder = this.getDocumentBuilder(loadedType, objectInitializationContext.getExtendedSearchIntegrator());
                if (documentBuilder == null || (previousValue = idToObjectMap.put(key = new EntityInfoLoadKey(loadedType, id = ReflectionHelper.getMemberValue((Object)unproxiedObject, (XMember)(idProperty = documentBuilder.getIdGetter()))), unproxiedObject)) != null) continue;
                throw new AssertionFailure("An entity got loaded even though it was not part of the EntityInfo list");
            }
        }
    }

    private void setCriteriaTimeout(Criteria criteria, TimeoutManager timeoutManager) {
        Long timeLeftInSecond;
        if (timeoutManager.getType() != TimeoutManager.Type.LIMIT && (timeLeftInSecond = timeoutManager.getTimeoutLeftInSeconds()) != null) {
            if (timeLeftInSecond == 0L) {
                timeoutManager.reactOnQueryTimeoutExceptionWhileExtracting(null);
            }
            criteria.setTimeout(timeLeftInSecond.intValue());
        }
    }

    private List<Criteria> buildUpCriteria(EntityInfo[] entityInfos, ObjectInitializationContext objectInitializationContext) {
        Map<Class<?>, EntityInfoIdSpace> infosByIdSpace = this.groupInfosByIdSpace(entityInfos, objectInitializationContext);
        if (infosByIdSpace.size() == 1) {
            EntityInfoIdSpace idSpace = infosByIdSpace.values().iterator().next();
            Criteria criteria = objectInitializationContext.getCriteria();
            if (criteria == null) {
                criteria = objectInitializationContext.getSession().createCriteria(idSpace.getMostSpecificEntityType());
            }
            criteria.add(this.getIdListCriterion(idSpace.getEntityInfos(), objectInitializationContext));
            return Collections.singletonList(criteria);
        }
        if (objectInitializationContext.getCriteria() != null) {
            log.givenCriteriaObjectCannotBeApplied();
        }
        ArrayList<Criteria> criterias = new ArrayList<Criteria>(infosByIdSpace.size());
        for (Map.Entry<Class<?>, EntityInfoIdSpace> infosOfIdSpace : infosByIdSpace.entrySet()) {
            EntityInfoIdSpace idSpace = infosOfIdSpace.getValue();
            Criteria criteria = objectInitializationContext.getSession().createCriteria(idSpace.getMostSpecificEntityType());
            criteria.add(this.getIdListCriterion(idSpace.getEntityInfos(), objectInitializationContext));
            criterias.add(criteria);
        }
        return criterias;
    }

    private Criterion getIdListCriterion(List<EntityInfo> entityInfos, ObjectInitializationContext objectInitializationContext) {
        boolean exact;
        DocumentBuilderIndexedEntity documentBuilder = this.getDocumentBuilder(entityInfos.iterator().next().getClazz(), objectInitializationContext.getExtendedSearchIntegrator());
        String idName = documentBuilder.getIdentifierName();
        Disjunction disjunction = Restrictions.disjunction();
        int maxResults = entityInfos.size();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        for (int index = 0; index < loop; ++index) {
            int max = Math.min(index * 500 + 500, maxResults);
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            for (int entityInfoIndex = index * 500; entityInfoIndex < max; ++entityInfoIndex) {
                ids.add(entityInfos.get(entityInfoIndex).getId());
            }
            disjunction.add(Restrictions.in((String)idName, ids));
        }
        return disjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<?>, EntityInfoIdSpace> groupInfosByIdSpace(EntityInfo[] entityInfos, ObjectInitializationContext objectInitializationContext) {
        ServiceManager serviceManager = objectInitializationContext.getExtendedSearchIntegrator().getServiceManager();
        IdUniquenessResolver resolver = (IdUniquenessResolver)serviceManager.requestService(IdUniquenessResolver.class);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)objectInitializationContext.getSession().getSessionFactory();
        try {
            HashMap idSpaces = new HashMap();
            for (EntityInfo entityInfo : entityInfos) {
                this.addToIdSpace(idSpaces, entityInfo, resolver, sessionFactory);
            }
            HashMap hashMap = idSpaces;
            return hashMap;
        }
        finally {
            serviceManager.releaseService(IdUniquenessResolver.class);
        }
    }

    private Class<?> getRootEntityType(SessionFactoryImplementor sessionFactory, Class<?> entityType) {
        String entityName = sessionFactory.getClassMetadata(entityType).getEntityName();
        String rootEntityName = sessionFactory.getEntityPersister(entityName).getRootEntityName();
        return sessionFactory.getEntityPersister(rootEntityName).getMappedClass();
    }

    private void addToIdSpace(Map<Class<?>, EntityInfoIdSpace> idSpaces, EntityInfo entityInfo, IdUniquenessResolver resolver, SessionFactoryImplementor sessionFactory) {
        for (Map.Entry<Class<?>, EntityInfoIdSpace> entry : idSpaces.entrySet()) {
            if (!resolver.areIdsUniqueForClasses(entityInfo.getClazz(), entry.getKey())) continue;
            entry.getValue().add(entityInfo);
            return;
        }
        Class<?> rootType = this.getRootEntityType(sessionFactory, entityInfo.getClazz());
        EntityInfoIdSpace entityInfoIdSpace = new EntityInfoIdSpace(rootType, entityInfo);
        idSpaces.put(this.getRootEntityType(sessionFactory, entityInfo.getClazz()), entityInfoIdSpace);
    }

    private DocumentBuilderIndexedEntity getDocumentBuilder(Class<?> entityType, ExtendedSearchIntegrator extendedIntegrator) {
        Set indexedEntities = extendedIntegrator.getIndexedTypesPolymorphic(new Class[]{entityType});
        if (indexedEntities.size() > 0) {
            return extendedIntegrator.getIndexBinding((Class)indexedEntities.iterator().next()).getDocumentBuilder();
        }
        return null;
    }

    private static class EntityInfoIdSpace {
        private final Class<?> rootType;
        private Class<?> mostSpecificEntityType;
        private List<EntityInfo> entityInfos = new ArrayList<EntityInfo>();

        private EntityInfoIdSpace(Class<?> rootType, EntityInfo entityInfo) {
            this.rootType = rootType;
            this.entityInfos.add(entityInfo);
            this.mostSpecificEntityType = entityInfo.getClazz();
        }

        private void add(EntityInfo entityInfo) {
            this.entityInfos.add(entityInfo);
            this.mostSpecificEntityType = this.getMostSpecificCommonSuperClass(this.mostSpecificEntityType, entityInfo.getClazz());
        }

        private Class<?> getMostSpecificCommonSuperClass(Class<?> class1, Class<?> class2) {
            if (this.rootType.equals(class1) || this.rootType.equals(class2)) {
                return this.rootType;
            }
            Class<?> superClass = class1;
            while (!superClass.isAssignableFrom(class2)) {
                superClass = superClass.getSuperclass();
            }
            return superClass;
        }

        private List<EntityInfo> getEntityInfos() {
            return this.entityInfos;
        }

        private Class<?> getMostSpecificEntityType() {
            return this.mostSpecificEntityType;
        }
    }
}

