/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.stats.ClusterCacheStats;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class ClusteredCacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final ClusteredCacheMetricsHandler INSTANCE = new ClusteredCacheMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getLastElement().getValue();
        String attrName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName));
        Cache cache = (Cache)controller.getValue();
        ClusteredCacheMetrics metric = ClusteredCacheMetrics.getStat(attrName);
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", attrName));
        } else if (cache == null) {
            context.getFailureDescription().set(String.format("Unavailable cache %s", attrName));
        } else {
            AdvancedCache aCache = cache.getAdvancedCache();
            ClusterCacheStats clusterCacheStats = (ClusterCacheStats)aCache.getComponentRegistry().getComponent(ClusterCacheStats.class);
            switch (metric) {
                case NUMBER_OF_LOCKS_AVAILABLE: {
                    result.set(clusterCacheStats.getNumberOfLocksAvailable());
                    break;
                }
                case NUMBER_OF_LOCKS_HELD: {
                    result.set(clusterCacheStats.getNumberOfLocksHeld());
                    break;
                }
                case AVERAGE_READ_TIME: {
                    result.set(clusterCacheStats.getAverageReadTime());
                    break;
                }
                case TIME_SINCE_START: {
                    result.set(clusterCacheStats.getTimeSinceStart());
                    break;
                }
                case AVERAGE_WRITE_TIME: {
                    result.set(clusterCacheStats.getAverageWriteTime());
                    break;
                }
                case AVERAGE_REMOVE_TIME: {
                    result.set(clusterCacheStats.getAverageRemoveTime());
                    break;
                }
                case EVICTIONS: {
                    result.set(clusterCacheStats.getEvictions());
                    break;
                }
                case HIT_RATIO: {
                    result.set(clusterCacheStats.getHitRatio());
                    break;
                }
                case HITS: {
                    result.set(clusterCacheStats.getHits());
                    break;
                }
                case MISSES: {
                    result.set(clusterCacheStats.getMisses());
                    break;
                }
                case NUMBER_OF_ENTRIES: {
                    result.set(clusterCacheStats.getCurrentNumberOfEntries());
                    break;
                }
                case NUMBER_OF_ENTRIES_IN_MEMORY: {
                    result.set(clusterCacheStats.getCurrentNumberOfEntriesInMemory());
                    break;
                }
                case OFF_HEAP_MEMORY_USED: {
                    result.set(clusterCacheStats.getOffHeapMemoryUsed());
                    break;
                }
                case READ_WRITE_RATIO: {
                    result.set(clusterCacheStats.getReadWriteRatio());
                    break;
                }
                case REMOVE_HITS: {
                    result.set(clusterCacheStats.getRemoveHits());
                    break;
                }
                case REMOVE_MISSES: {
                    result.set(clusterCacheStats.getRemoveMisses());
                    break;
                }
                case STORES: {
                    result.set(clusterCacheStats.getStores());
                    break;
                }
                case TIME_SINCE_RESET: {
                    result.set(clusterCacheStats.getTimeSinceReset());
                    break;
                }
                case INVALIDATIONS: {
                    result.set(clusterCacheStats.getInvalidations());
                    break;
                }
                case PASSIVATIONS: {
                    result.set(clusterCacheStats.getPassivations());
                    break;
                }
                case ACTIVATIONS: {
                    result.set(clusterCacheStats.getActivations());
                    break;
                }
                case CACHE_LOADER_LOADS: {
                    result.set(clusterCacheStats.getCacheLoaderLoads());
                    break;
                }
                case CACHE_LOADER_MISSES: {
                    result.set(clusterCacheStats.getCacheLoaderMisses());
                    break;
                }
                case CACHE_LOADER_STORES: {
                    result.set(clusterCacheStats.getStoreWrites());
                    break;
                }
                case STALE_STATS_THRESHOLD: {
                    result.set(clusterCacheStats.getStaleStatsThreshold());
                    break;
                }
                default: {
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    public void registerClusteredMetrics(ManagementResourceRegistration container) {
        for (ClusteredCacheMetrics metric : ClusteredCacheMetrics.values()) {
            if (!metric.clustered) continue;
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static enum ClusteredCacheMetrics {
        NUMBER_OF_LOCKS_AVAILABLE("clusterwide-number-of-locks-available", ModelType.INT, true),
        NUMBER_OF_LOCKS_HELD("clusterwide-number-of-locks-held", ModelType.INT, true),
        AVERAGE_READ_TIME("clusterwide-average-read-time", ModelType.LONG, true),
        AVERAGE_WRITE_TIME("clusterwide-average-write-time", ModelType.LONG, true),
        AVERAGE_REMOVE_TIME("clusterwide-average-remove-time", ModelType.LONG, true),
        TIME_SINCE_START("clusterwide-time-since-start", ModelType.LONG, true),
        EVICTIONS("clusterwide-evictions", ModelType.LONG, true),
        HIT_RATIO("clusterwide-hit-ratio", ModelType.DOUBLE, true),
        HITS("clusterwide-hits", ModelType.LONG, true),
        MISSES("clusterwide-misses", ModelType.LONG, true),
        NUMBER_OF_ENTRIES("clusterwide-number-of-entries", ModelType.INT, true),
        NUMBER_OF_ENTRIES_IN_MEMORY("clusterwide-number-of-entries-in-memory", ModelType.INT, true),
        OFF_HEAP_MEMORY_USED("clusterwide-off-heap-memory-used", ModelType.LONG, true),
        READ_WRITE_RATIO("clusterwide-read-write-ratio", ModelType.DOUBLE, true),
        REMOVE_HITS("clusterwide-remove-hits", ModelType.LONG, true),
        REMOVE_MISSES("clusterwide-remove-misses", ModelType.LONG, true),
        STORES("clusterwide-stores", ModelType.LONG, true),
        TIME_SINCE_RESET("clusterwide-time-since-reset", ModelType.LONG, true),
        INVALIDATIONS("clusterwide-invalidations", ModelType.LONG, true),
        PASSIVATIONS("clusterwide-passivations", ModelType.STRING, true),
        ACTIVATIONS("clusterwide-activations", ModelType.STRING, true),
        CACHE_LOADER_LOADS("clusterwide-cache-loader-loads", ModelType.LONG, true),
        CACHE_LOADER_MISSES("clusterwide-cache-loader-misses", ModelType.LONG, true),
        CACHE_LOADER_STORES("clusterwide-cache-loader-stores", ModelType.LONG, true),
        STALE_STATS_THRESHOLD("clusterwide-stale-stats-threshold", ModelType.LONG, true);

        private static final Map<String, ClusteredCacheMetrics> MAP;
        final AttributeDefinition definition;
        final boolean clustered;

        private ClusteredCacheMetrics(AttributeDefinition definition, boolean clustered) {
            this.definition = definition;
            this.clustered = clustered;
        }

        private ClusteredCacheMetrics(String attributeName, ModelType type, boolean allowNull) {
            this((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type, allowNull).setStorageRuntime()).build(), true);
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static ClusteredCacheMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, ClusteredCacheMetrics>();
            for (ClusteredCacheMetrics metric : ClusteredCacheMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

