/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongUnaryOperator;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapLruNode;
import org.infinispan.eviction.EvictionType;
import org.infinispan.metadata.Metadata;

public class BoundedOffHeapDataContainer
extends OffHeapDataContainer {
    protected final long maxSize;
    protected final Lock lruLock;
    protected final LongUnaryOperator sizeCalculator;
    protected long currentSize;
    protected long firstAddress;
    protected long lastAddress;

    public BoundedOffHeapDataContainer(int desiredSize, long maxSize, EvictionType type) {
        super(desiredSize);
        this.maxSize = maxSize;
        this.sizeCalculator = type == EvictionType.COUNT ? i -> 1L : i -> this.offHeapEntryFactory.getSize(i);
        this.lruLock = new ReentrantLock();
        this.firstAddress = 0L;
    }

    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        super.put(key, value, metadata);
        this.ensureSize();
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryReplaced(long newAddress, long oldAddress) {
        long oldSize = this.sizeCalculator.applyAsLong(oldAddress);
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            this.removeNode(oldAddress);
            this.addEntryAddressToEnd(newAddress);
            this.currentSize += newSize;
            this.currentSize -= oldSize;
            super.entryReplaced(newAddress, oldAddress);
        }
        finally {
            this.lruLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryCreated(long newAddress) {
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            this.currentSize += newSize;
            this.addEntryAddressToEnd(newAddress);
            super.entryCreated(newAddress);
        }
        finally {
            this.lruLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryRemoved(long removedAddress) {
        long removedSize = this.sizeCalculator.applyAsLong(removedAddress);
        this.lruLock.lock();
        try {
            this.currentSize -= removedSize;
            this.removeNode(removedAddress);
            super.entryRemoved(removedAddress);
        }
        finally {
            this.lruLock.unlock();
        }
    }

    private void removeNode(long address) {
        long previousLRUNode;
        boolean middleNode = true;
        if (address == this.lastAddress) {
            if (this.trace) {
                this.log.tracef("Removed entry 0x%016x from the end of the LRU list", address);
            }
            if ((previousLRUNode = OffHeapLruNode.getPrevious(address)) != 0L) {
                OffHeapLruNode.setNext(previousLRUNode, 0L);
            }
            this.lastAddress = previousLRUNode;
            middleNode = false;
        }
        if (address == this.firstAddress) {
            long nextLRUNode;
            if (this.trace) {
                this.log.tracef("Removed entry 0x%016x from the beginning of the LRU list", address);
            }
            if ((nextLRUNode = OffHeapLruNode.getNext(address)) != 0L) {
                OffHeapLruNode.setPrevious(nextLRUNode, 0L);
            }
            this.firstAddress = nextLRUNode;
            middleNode = false;
        }
        if (middleNode) {
            if (this.trace) {
                this.log.tracef("Removed entry 0x%016x from the middle of the LRU list", address);
            }
            previousLRUNode = OffHeapLruNode.getPrevious(address);
            long nextLRUNode = OffHeapLruNode.getNext(address);
            assert (previousLRUNode != 0L);
            assert (nextLRUNode != 0L);
            OffHeapLruNode.setNext(previousLRUNode, nextLRUNode);
            OffHeapLruNode.setPrevious(nextLRUNode, previousLRUNode);
        }
    }

    @Override
    protected void entryRetrieved(long entryAddress) {
        this.lruLock.lock();
        try {
            if (this.trace) {
                this.log.tracef("Moving entry 0x%016x to the end of the LRU list", entryAddress);
            }
            this.moveToEnd(entryAddress);
            super.entryRetrieved(entryAddress);
        }
        finally {
            this.lruLock.unlock();
        }
    }

    @Override
    protected void performClear() {
        if (this.trace) {
            this.log.trace("Clearing bounded LRU entries");
        }
        this.lruLock.lock();
        try {
            this.currentSize = 0L;
            this.firstAddress = 0L;
            this.lastAddress = 0L;
        }
        finally {
            this.lruLock.unlock();
        }
        if (this.trace) {
            this.log.trace("Cleared bounded LRU entries");
        }
        super.performClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureSize() {
        while (true) {
            long addressToRemove;
            Lock entryWriteLock;
            int hashCode;
            this.lruLock.lock();
            try {
                if (this.currentSize <= this.maxSize) return;
                hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress);
                entryWriteLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                addressToRemove = !entryWriteLock.tryLock() ? 0L : this.firstAddress;
            }
            finally {
                this.lruLock.unlock();
            }
            if (addressToRemove == 0L) {
                entryWriteLock.lock();
                try {
                    this.lruLock.lock();
                    try {
                        if (this.currentSize <= this.maxSize) return;
                        hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress);
                        Lock innerLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                        addressToRemove = innerLock == entryWriteLock ? this.firstAddress : 0L;
                    }
                    finally {
                        this.lruLock.unlock();
                    }
                }
                finally {
                    if (addressToRemove == 0L) {
                        entryWriteLock.unlock();
                    }
                }
            }
            if (addressToRemove == 0L) continue;
            if (this.trace) {
                this.log.tracef("Removing entry: 0x%016x due to eviction due to size %d being larger than maximum of %d", addressToRemove, this.currentSize, this.maxSize);
            }
            try {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(addressToRemove);
                this.passivator.passivate(ice);
                this.performRemove(this.memoryLookup.getMemoryAddress(ice.getKey()), addressToRemove, ice.getKey(), false);
                this.evictionManager.onEntryEviction(Collections.singletonMap(ice.getKey(), ice));
                continue;
            }
            finally {
                entryWriteLock.unlock();
                continue;
            }
            break;
        }
    }

    private void addEntryAddressToEnd(long entryAddress) {
        if (this.trace) {
            this.log.tracef("Adding entry 0x%016x to the end of the LRU list", entryAddress);
        }
        if (this.lastAddress == 0L) {
            this.firstAddress = entryAddress;
            this.lastAddress = entryAddress;
            OffHeapLruNode.setPrevious(entryAddress, 0L);
        } else {
            OffHeapLruNode.setPrevious(entryAddress, this.lastAddress);
            OffHeapLruNode.setNext(this.lastAddress, entryAddress);
            this.lastAddress = entryAddress;
        }
        OffHeapLruNode.setNext(entryAddress, 0L);
    }

    private void moveToEnd(long lruNode) {
        if (lruNode != this.lastAddress) {
            long nextLruNode = OffHeapLruNode.getNext(lruNode);
            assert (nextLruNode != 0L);
            if (lruNode == this.firstAddress) {
                OffHeapLruNode.setPrevious(nextLruNode, 0L);
                this.firstAddress = nextLruNode;
            } else {
                long prevLruNode = OffHeapLruNode.getPrevious(lruNode);
                assert (prevLruNode != 0L);
                OffHeapLruNode.setNext(prevLruNode, nextLruNode);
                OffHeapLruNode.setPrevious(nextLruNode, prevLruNode);
            }
            OffHeapLruNode.setNext(this.lastAddress, lruNode);
            OffHeapLruNode.setPrevious(lruNode, this.lastAddress);
            OffHeapLruNode.setNext(lruNode, 0L);
            this.lastAddress = lruNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> debugLruList() {
        if (this.firstAddress == 0L) {
            return Collections.emptyList();
        }
        this.lruLock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>(this.sizeIncludingExpired());
            long a = this.firstAddress;
            while (a != 0L) {
                long n = OffHeapLruNode.getNext(a);
                list.add(OffHeapLruNode.debugString(a));
                assert (n == 0L || OffHeapLruNode.getPrevious(n) == a);
                a = OffHeapLruNode.getNext(a);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.lruLock.unlock();
        }
    }
}

