/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.MemoryAddressHash;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.StripedLock;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OffHeapDataContainer
implements DataContainer<WrappedBytes, WrappedBytes> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.log.isTraceEnabled();
    protected final AtomicLong size = new AtomicLong();
    protected final int lockCount = OffHeapDataContainer.nextPowerOfTwo(Runtime.getRuntime().availableProcessors()) << 1;
    protected final int memoryAddressCount;
    protected final StripedLock locks;
    protected final MemoryAddressHash memoryLookup;
    protected OffHeapMemoryAllocator allocator;
    protected OffHeapEntryFactory offHeapEntryFactory;
    protected InternalEntryFactory internalEntryFactory;
    protected TimeService timeService;
    protected EvictionManager evictionManager;
    protected PassivationManager passivator;
    private boolean dellocated = false;
    private static final int MAX_LOCK_COUNT = 0x40000000;

    static int nextPowerOfTwo(int target) {
        int n = target - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public OffHeapDataContainer(int desiredSize) {
        int memoryAddresses;
        int n = memoryAddresses = desiredSize >= 0x40000000 ? 0x40000000 : this.lockCount;
        while (memoryAddresses < desiredSize) {
            memoryAddresses <<= 1;
        }
        this.memoryAddressCount = memoryAddresses;
        this.memoryLookup = new MemoryAddressHash(this.memoryAddressCount);
        this.locks = new StripedLock(this.lockCount);
    }

    @Inject
    public void inject(EvictionManager evictionManager, PassivationManager passivator, OffHeapEntryFactory offHeapEntryFactory, OffHeapMemoryAllocator allocator, TimeService timeService, InternalEntryFactory internalEntryFactory) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.internalEntryFactory = internalEntryFactory;
        this.allocator = allocator;
        this.offHeapEntryFactory = offHeapEntryFactory;
        this.timeService = timeService;
    }

    @Stop(priority=0x7FFFFFFF)
    public void deallocate() {
        this.locks.lockAll();
        try {
            if (this.size.get() != 0L) {
                this.log.warn("Container was not cleared before deallocating memory lookup tables!  Memory leak will have occurred!");
            }
            this.clear();
            this.memoryLookup.deallocate();
            this.dellocated = true;
        }
        finally {
            this.locks.unlockAll();
        }
    }

    static WrappedByteArray toWrapper(Object obj) {
        if (obj instanceof WrappedByteArray) {
            return (WrappedByteArray)obj;
        }
        throw new IllegalArgumentException("Require WrappedByteArray: got " + obj.getClass());
    }

    protected void checkDeallocation() {
        if (this.dellocated) {
            throw new IllegalStateException("Container was already shut down!");
        }
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> get(Object k) {
        return this.peekOrGet(k, false);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> peek(Object k) {
        return this.peekOrGet(k, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalCacheEntry<WrappedBytes, WrappedBytes> peekOrGet(Object k, boolean peek) {
        Lock lock = this.locks.getLock(k).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(k);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performGet(address, k, peek);
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    protected InternalCacheEntry<WrappedBytes, WrappedBytes> performGet(long address, Object k, boolean peek) {
        WrappedByteArray wrappedKey = OffHeapDataContainer.toWrapper(k);
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(address);
            if (wrappedKey.equalsWrappedBytes((WrappedBytes)ice.getKey())) {
                if (!peek) {
                    this.entryRetrieved(address);
                }
                return ice;
            }
            address = nextAddress;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long newAddress = this.offHeapEntryFactory.create(key, value, metadata);
            long address = this.memoryLookup.getMemoryAddress(key);
            this.performPut(address, newAddress, key);
        }
        finally {
            lock.unlock();
        }
    }

    protected void performPut(long address, long newAddress, WrappedBytes key) {
        if (address == 0L) {
            this.memoryLookup.putMemoryAddress(key, newAddress);
            this.entryCreated(newAddress);
            this.size.incrementAndGet();
        } else {
            boolean replaceHead = false;
            boolean foundKey = false;
            long prevAddress = 0L;
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                if (!foundKey && this.offHeapEntryFactory.equalsKey(address, key)) {
                    this.entryReplaced(newAddress, address);
                    foundKey = true;
                    if (prevAddress == 0L) {
                        if (nextAddress == 0L) {
                            replaceHead = true;
                        } else {
                            this.memoryLookup.putMemoryAddress(key, nextAddress);
                        }
                    } else {
                        this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                        address = nextAddress;
                        continue;
                    }
                }
                prevAddress = address;
                address = nextAddress;
            }
            if (!foundKey) {
                this.entryCreated(newAddress);
                this.size.incrementAndGet();
            }
            if (replaceHead) {
                this.memoryLookup.putMemoryAddress(key, newAddress);
            } else {
                this.offHeapEntryFactory.setNext(prevAddress, newAddress);
            }
        }
    }

    protected void entryCreated(long newAddress) {
    }

    protected void entryReplaced(long newAddress, long oldAddress) {
        this.allocator.deallocate(oldAddress);
    }

    protected void entryRemoved(long removedAddress) {
        this.allocator.deallocate(removedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object k) {
        Lock lock = this.locks.getLock(k).readLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(k);
            if (address == 0L) {
                boolean bl = false;
                return bl;
            }
            WrappedByteArray wba = OffHeapDataContainer.toWrapper(k);
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                if (this.offHeapEntryFactory.equalsKey(address, (WrappedBytes)wba)) {
                    boolean bl = true;
                    return bl;
                }
                address = nextAddress;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected void entryRetrieved(long entryAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> remove(Object key) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performRemove(address, 0L, key, true);
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    protected InternalCacheEntry<WrappedBytes, WrappedBytes> performRemove(long bucketHeadAddress, long actualAddress, Object key, boolean requireReturn) {
        WrappedByteArray wba = OffHeapDataContainer.toWrapper(key);
        long prevAddress = 0L;
        long address = bucketHeadAddress;
        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = null;
        while (address != 0L) {
            boolean removeThisAddress;
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            boolean bl = actualAddress == 0L ? this.offHeapEntryFactory.equalsKey(address, (WrappedBytes)wba) : (removeThisAddress = actualAddress == address);
            if (removeThisAddress) {
                if (requireReturn) {
                    ice = this.offHeapEntryFactory.fromMemory(address);
                }
                this.entryRemoved(address);
                if (prevAddress != 0L) {
                    this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                } else {
                    this.memoryLookup.putMemoryAddress(key, nextAddress);
                }
                this.size.decrementAndGet();
                break;
            }
            prevAddress = address;
            address = nextAddress;
        }
        return ice;
    }

    @Override
    public int size() {
        long time = this.timeService.wallClockTime();
        long count = this.entryStream().filter(e -> !e.isExpired(time)).count();
        return (int)Math.min(count, Integer.MAX_VALUE);
    }

    @Override
    public int sizeIncludingExpired() {
        return (int)Math.min(this.size.get(), Integer.MAX_VALUE);
    }

    @Override
    public void clear() {
        this.locks.lockAll();
        try {
            this.checkDeallocation();
            this.performClear();
        }
        finally {
            this.locks.unlockAll();
        }
    }

    protected void performClear() {
        if (this.trace) {
            this.log.trace("Clearing off heap data");
        }
        this.memoryLookup.toStreamRemoved().forEach((long address) -> {
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                this.allocator.deallocate(address);
                address = nextAddress;
            }
        });
        this.size.set(0L);
        if (this.trace) {
            this.log.trace("Cleared off heap data");
        }
    }

    @Override
    public Set<WrappedBytes> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<WrappedBytes> values() {
        return new ValueCollection();
    }

    @Override
    public Set<InternalCacheEntry<WrappedBytes, WrappedBytes>> entrySet() {
        return new EntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(WrappedBytes key) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            InternalCacheEntry<WrappedBytes, WrappedBytes> ice;
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            if (address != 0L && (ice = this.performGet(address, key, true)) != null) {
                this.passivator.passivate(ice);
                this.performRemove(address, 0L, key, false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        Lock lock = this.locks.getLock(key).writeLock();
        lock.lock();
        try {
            this.checkDeallocation();
            long address = this.memoryLookup.getMemoryAddress(key);
            InternalCacheEntry<WrappedBytes, WrappedBytes> prev = address == 0L ? null : this.performGet(address, key, true);
            InternalCacheEntry<WrappedBytes, WrappedBytes> result = action.compute(key, prev, this.internalEntryFactory);
            if (prev != result) {
                if (result != null) {
                    long newAddress = this.offHeapEntryFactory.create(key, (WrappedBytes)result.getValue(), result.getMetadata());
                    this.performPut(address, newAddress, key);
                } else {
                    this.performRemove(address, 0L, key, false);
                }
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = result;
            return internalCacheEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(Consumer<InternalCacheEntry<WrappedBytes, WrappedBytes>> consumer) {
        for (int i = 0; i < this.lockCount; ++i) {
            Lock lock = this.locks.getLockWithOffset(i).readLock();
            lock.lock();
            try {
                this.checkDeallocation();
                for (int j = i; j < this.memoryAddressCount; j += this.lockCount) {
                    long address = this.memoryLookup.getMemoryAddressOffset(j);
                    while (address != 0L) {
                        long nextAddress = this.offHeapEntryFactory.getNext(address);
                        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(address);
                        consumer.accept(ice);
                        address = nextAddress;
                    }
                }
                continue;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void executeTask(KeyFilter<? super WrappedBytes> filter, BiConsumer<? super WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>> action) throws InterruptedException {
        this.executeTask(ice -> {
            if (filter.accept((WrappedBytes)ice.getKey())) {
                action.accept((WrappedBytes)ice.getKey(), (InternalCacheEntry<WrappedBytes, WrappedBytes>)ice);
            }
        });
    }

    @Override
    public void executeTask(KeyValueFilter<? super WrappedBytes, ? super WrappedBytes> filter, BiConsumer<? super WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>> action) throws InterruptedException {
        this.executeTask(ice -> {
            if (filter.accept((WrappedBytes)ice.getKey(), (WrappedBytes)ice.getValue(), ice.getMetadata())) {
                action.accept((WrappedBytes)ice.getKey(), (InternalCacheEntry<WrappedBytes, WrappedBytes>)ice);
            }
        });
    }

    private Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> entryStream() {
        return IntStream.range(0, this.memoryAddressCount).mapToObj(a -> {
            Lock lock = this.locks.getLockWithOffset(a % this.lockCount).readLock();
            lock.lock();
            try {
                long nextAddress;
                this.checkDeallocation();
                long address = this.memoryLookup.getMemoryAddressOffset(a);
                if (address == 0L) {
                    Stream stream = null;
                    return stream;
                }
                Stream.Builder<InternalCacheEntry<WrappedBytes, WrappedBytes>> builder = Stream.builder();
                do {
                    nextAddress = this.offHeapEntryFactory.getNext(address);
                    builder.accept(this.offHeapEntryFactory.fromMemory(address));
                } while ((address = nextAddress) != 0L);
                Stream stream = builder.build();
                return stream;
            }
            finally {
                lock.unlock();
            }
        }).flatMap(Function.identity());
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
        long time = this.timeService.wallClockTime();
        return this.entryStream().filter(e -> !e.isExpired(time)).iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iteratorIncludingExpired() {
        return this.entryStream().iterator();
    }

    class EntrySet
    extends AbstractSet<InternalCacheEntry<WrappedBytes, WrappedBytes>> {
        EntrySet() {
        }

        @Override
        public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
            return this.stream().iterator();
        }

        @Override
        public int size() {
            return OffHeapDataContainer.this.size();
        }

        @Override
        public void forEach(Consumer<? super InternalCacheEntry<WrappedBytes, WrappedBytes>> action) {
            this.stream().forEach(action);
        }

        @Override
        public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> stream() {
            return OffHeapDataContainer.this.entryStream();
        }

        @Override
        public Stream<InternalCacheEntry<WrappedBytes, WrappedBytes>> parallelStream() {
            return (Stream)this.stream().parallel();
        }
    }

    class KeySet
    extends ValueCollection
    implements Set<WrappedBytes> {
        KeySet() {
        }

        @Override
        public Stream<WrappedBytes> stream() {
            return OffHeapDataContainer.this.entryStream().map(Map.Entry::getKey);
        }

        @Override
        public boolean contains(Object o) {
            return OffHeapDataContainer.this.containsKey(o);
        }
    }

    class ValueCollection
    extends AbstractCollection<WrappedBytes> {
        ValueCollection() {
        }

        @Override
        public Iterator<WrappedBytes> iterator() {
            return this.stream().iterator();
        }

        @Override
        public void forEach(Consumer<? super WrappedBytes> action) {
            this.stream().forEach(action);
        }

        @Override
        public Spliterator<WrappedBytes> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public Stream<WrappedBytes> stream() {
            return OffHeapDataContainer.this.entryStream().map(Map.Entry::getValue);
        }

        @Override
        public Stream<WrappedBytes> parallelStream() {
            return (Stream)this.stream().parallel();
        }

        @Override
        public int size() {
            return OffHeapDataContainer.this.size();
        }
    }
}

