/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.dataconversion.BinaryEncoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.CompatModeEncoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.EncoderRegistry;

public class DataConversion {
    public static final DataConversion DEFAULT_KEY = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)ByteArrayWrapper.INSTANCE, true);
    public static final DataConversion DEFAULT_VALUE = new DataConversion((Encoder)IdentityEncoder.INSTANCE, (Wrapper)ByteArrayWrapper.INSTANCE, false);
    private Class<? extends Encoder> encoderClass;
    private Class<? extends Wrapper> wrapperClass;
    private MediaType requestMediaType;
    private MediaType storageMediaType;
    private Short encoderId;
    private Byte wrapperId;
    private Encoder encoder;
    private Wrapper wrapper;
    private boolean isKey;
    private Transcoder transcoder;

    private DataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass, MediaType requestMediaType, MediaType storageMediaType, boolean isKey) {
        this.encoderClass = encoderClass;
        this.wrapperClass = wrapperClass;
        this.requestMediaType = requestMediaType;
        this.storageMediaType = storageMediaType;
        this.isKey = isKey;
    }

    private DataConversion(Short encoderId, Byte wrapperId, MediaType requestMediaType, MediaType storageMediaType, boolean isKey) {
        this.encoderId = encoderId;
        this.wrapperId = wrapperId;
        this.requestMediaType = requestMediaType;
        this.storageMediaType = storageMediaType;
        this.isKey = isKey;
    }

    private DataConversion(Encoder encoder, Wrapper wrapper, boolean isKey) {
        this.encoder = encoder;
        this.wrapper = wrapper;
        this.encoderClass = encoder.getClass();
        this.wrapperClass = wrapper.getClass();
        this.isKey = isKey;
    }

    public DataConversion withRequestMediaType(MediaType requestMediaType) {
        if (Objects.equals(this.requestMediaType, requestMediaType)) {
            return this;
        }
        return new DataConversion(this.encoderClass, this.wrapperClass, requestMediaType, this.storageMediaType, this.isKey);
    }

    public DataConversion withEncoding(Class<? extends Encoder> encoderClass) {
        if (Objects.equals(this.encoderClass, encoderClass)) {
            return this;
        }
        return new DataConversion(encoderClass, this.wrapperClass, this.requestMediaType, this.storageMediaType, this.isKey);
    }

    public DataConversion withWrapping(Class<? extends Wrapper> wrapperClass) {
        if (Objects.equals(this.wrapperClass, wrapperClass)) {
            return this;
        }
        return new DataConversion(this.encoderClass, wrapperClass, this.requestMediaType, this.storageMediaType, this.isKey);
    }

    public void overrideWrapper(Class<? extends Wrapper> newWrapper, ComponentRegistry cr) {
        this.wrapper = null;
        this.wrapperClass = newWrapper;
        cr.wireDependencies(this);
    }

    private MediaType getStorageMediaType(Configuration configuration, boolean embeddedMode) {
        ContentTypeConfiguration contentTypeConfiguration;
        EncodingConfiguration encodingConfiguration = configuration.encoding();
        ContentTypeConfiguration contentTypeConfiguration2 = contentTypeConfiguration = this.isKey ? encodingConfiguration.keyDataType() : encodingConfiguration.valueDataType();
        if (contentTypeConfiguration.isMediaTypeChanged()) {
            return contentTypeConfiguration.mediaType();
        }
        if (configuration.compatibility().enabled()) {
            return MediaType.APPLICATION_OBJECT;
        }
        if (!embeddedMode && configuration.indexing().index().isEnabled() && contentTypeConfiguration.mediaType() == null) {
            return MediaType.APPLICATION_PROTOSTREAM;
        }
        return null;
    }

    @Inject
    public void injectDependencies(GlobalConfiguration gcr, EncoderRegistry encoderRegistry, Configuration configuration) {
        boolean isEncodingEmpty;
        boolean embeddedMode = Configurations.isEmbeddedMode(gcr);
        CompatibilityModeConfiguration compatibility = configuration.compatibility();
        boolean compat = compatibility.enabled();
        StorageType storageType = configuration.memory().storageType();
        boolean offheap = storageType == StorageType.OFF_HEAP;
        boolean binary = storageType == StorageType.BINARY;
        boolean bl = isEncodingEmpty = this.encoderClass == null && this.encoderId == null && this.encoder == null;
        if (isEncodingEmpty) {
            this.encoderClass = IdentityEncoder.class;
            if (offheap && embeddedMode) {
                this.encoderClass = GlobalMarshallerEncoder.class;
            }
            if (binary) {
                this.encoderClass = BinaryEncoder.class;
            }
            if (compat) {
                this.encoderClass = embeddedMode ? IdentityEncoder.class : CompatModeEncoder.class;
            }
        }
        this.lookupWrapper(encoderRegistry);
        this.lookupEncoder(encoderRegistry, compatibility);
        this.storageMediaType = this.getStorageMediaType(configuration, embeddedMode);
        this.lookupTranscoder(encoderRegistry);
    }

    private void lookupTranscoder(EncoderRegistry encoderRegistry) {
        boolean needsTranscoding;
        boolean bl = needsTranscoding = this.storageMediaType != null && this.requestMediaType != null && !this.requestMediaType.equals((Object)this.storageMediaType);
        if (needsTranscoding) {
            Transcoder directTranscoder = null;
            if (this.encoder.getStorageFormat() != null) {
                try {
                    directTranscoder = encoderRegistry.getTranscoder(this.requestMediaType, this.encoder.getStorageFormat());
                }
                catch (EncodingException encodingException) {
                    // empty catch block
                }
            }
            if (directTranscoder != null) {
                if (this.encoder.getStorageFormat().equals((Object)MediaType.APPLICATION_OBJECT)) {
                    this.encoder = IdentityEncoder.INSTANCE;
                }
                this.transcoder = directTranscoder;
            } else {
                this.transcoder = encoderRegistry.getTranscoder(this.requestMediaType, this.storageMediaType);
            }
        }
    }

    private void lookupEncoder(EncoderRegistry encoderRegistry, CompatibilityModeConfiguration compatConfig) {
        if (!compatConfig.enabled()) {
            this.encoder = encoderRegistry.getEncoder(this.encoderClass, this.encoderId);
        } else if (this.encoderClass == null || this.encoderClass.equals(CompatModeEncoder.class)) {
            this.encoderClass = CompatModeEncoder.class;
            Marshaller compatMarshaller = compatConfig.marshaller();
            this.encoder = new CompatModeEncoder(compatMarshaller);
        } else {
            this.encoder = encoderRegistry.getEncoder(this.encoderClass, this.encoderId);
        }
    }

    private void lookupWrapper(EncoderRegistry encoderRegistry) {
        this.wrapper = encoderRegistry.getWrapper(this.wrapperClass, this.wrapperId);
    }

    public Object fromStorage(Object stored) {
        if (stored == null) {
            return null;
        }
        Object fromStorage = this.encoder.fromStorage(this.wrapper.unwrap(stored));
        return this.transcoder == null ? fromStorage : this.transcoder.transcode(fromStorage, this.storageMediaType, this.requestMediaType);
    }

    public Object toStorage(Object toStore) {
        if (toStore == null) {
            return null;
        }
        toStore = this.transcoder == null ? toStore : this.transcoder.transcode(toStore, this.requestMediaType, this.storageMediaType);
        return this.wrapper.wrap(this.encoder.toStorage(toStore));
    }

    public Object extractIndexable(Object stored) {
        if (stored == null) {
            return null;
        }
        if (this.encoder.isStorageFormatFilterable()) {
            return this.wrapper.isFilterable() ? stored : this.wrapper.unwrap(stored);
        }
        return this.encoder.fromStorage(this.wrapper.isFilterable() ? stored : this.wrapper.unwrap(stored));
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public Class<? extends Encoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Wrapper> getWrapperClass() {
        return this.wrapperClass;
    }

    public boolean isStorageFormatFilterable() {
        return this.encoder.isStorageFormatFilterable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConversion that = (DataConversion)o;
        return Objects.equals(this.encoder, that.encoder) && Objects.equals(this.wrapper, that.wrapper) && Objects.equals(this.transcoder, that.transcoder);
    }

    public String toString() {
        return "DataConversion{encoderClass=" + this.encoderClass + ", wrapperClass=" + this.wrapperClass + ", requestMediaType=" + this.requestMediaType + ", storageMediaType=" + this.storageMediaType + ", encoderId=" + this.encoderId + ", wrapperId=" + this.wrapperId + ", encoder=" + this.encoder + ", wrapper=" + this.wrapper + ", isKey=" + this.isKey + ", transcoder=" + this.transcoder + '}';
    }

    public int hashCode() {
        return Objects.hash(this.encoderClass, this.wrapperClass);
    }

    public static DataConversion newKeyDataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass, MediaType requestType) {
        return new DataConversion(encoderClass, wrapperClass, requestType, null, true);
    }

    public static DataConversion newValueDataConversion(Class<? extends Encoder> encoderClass, Class<? extends Wrapper> wrapperClass, MediaType requestType) {
        return new DataConversion(encoderClass, wrapperClass, requestType, null, false);
    }

    public static class Externalizer
    extends AbstractExternalizer<DataConversion> {
        public Set<Class<? extends DataConversion>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{DataConversion.class});
        }

        private boolean isDefault(DataConversion dataConversion) {
            return dataConversion.isKey && dataConversion.equals(DEFAULT_KEY) || !dataConversion.isKey && dataConversion.equals(DEFAULT_VALUE);
        }

        public void writeObject(ObjectOutput output, DataConversion dataConversion) throws IOException {
            if (this.isDefault(dataConversion)) {
                output.writeByte(1);
            } else {
                int flags = 0;
                if (dataConversion.isKey) {
                    flags = (byte)(flags | 2);
                }
                output.writeByte(flags);
                output.writeShort(dataConversion.encoder.id());
                output.writeByte(dataConversion.wrapper.id());
                output.writeObject(dataConversion.requestMediaType);
            }
        }

        public DataConversion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean isKey;
            byte flags = input.readByte();
            boolean bl = isKey = (flags & 2) == 2;
            if ((flags & 1) == 1) {
                return isKey ? DEFAULT_KEY : DEFAULT_VALUE;
            }
            short encoderId = input.readShort();
            byte wrapperId = input.readByte();
            MediaType requestMediaType = (MediaType)input.readObject();
            return new DataConversion(encoderId, wrapperId, requestMediaType, null, isKey);
        }

        public Integer getId() {
            return 131;
        }
    }
}

