/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=Externalizer.class)
public class CacheState {
    private final String configuration;
    private final EnumSet<CacheContainerAdmin.AdminFlag> flags;

    CacheState(String configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.configuration = configuration;
        this.flags = flags.clone();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public EnumSet<CacheContainerAdmin.AdminFlag> getFlags() {
        return this.flags;
    }

    public static class Externalizer
    implements AdvancedExternalizer<CacheState> {
        public void writeObject(ObjectOutput output, CacheState state) throws IOException {
            output.writeUTF(state.configuration);
            output.writeObject(state.flags);
        }

        public CacheState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String configuration = input.readUTF();
            EnumSet<CacheContainerAdmin.AdminFlag> flags = (EnumSet<CacheContainerAdmin.AdminFlag>)input.readObject();
            return new CacheState(configuration, flags == null ? EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class) : flags);
        }

        public Set<Class<? extends CacheState>> getTypeClasses() {
            return Collections.singleton(CacheState.class);
        }

        public Integer getId() {
            return 136;
        }
    }
}

