/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileLock;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.PostStart;
import org.infinispan.factories.annotations.Start;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationStateListener;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalConfigurationManagerImpl
implements GlobalConfigurationManager {
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private GlobalConfiguration globalConfiguration;
    private EmbeddedCacheManager cacheManager;
    private Cache<ScopedState, Object> stateCache;
    public static final String CACHE_SCOPE = "cache";
    private ParserRegistry parserRegistry;
    private ConcurrentHashSet<String> persistentCaches;

    @Inject
    public void inject(GlobalConfiguration globalConfiguration, EmbeddedCacheManager cacheManager) {
        this.globalConfiguration = globalConfiguration;
        this.cacheManager = cacheManager;
    }

    @Start
    public void start() {
        InternalCacheRegistry internalCacheRegistry = this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("org.infinispan.CONFIG", new ConfigurationBuilder().build(), EnumSet.of(InternalCacheRegistry.Flag.GLOBAL));
        this.parserRegistry = new ParserRegistry();
        this.persistentCaches = new ConcurrentHashSet();
    }

    @PostStart
    public void postStart() {
        CloseableIterator closeableIterator = this.getStateCache().entrySet().iterator();
        while (closeableIterator.hasNext()) {
            Map.Entry e = (Map.Entry)closeableIterator.next();
            if (!CACHE_SCOPE.equals(((ScopedState)e.getKey()).getScope())) continue;
            this.localCreateCache(((ScopedState)e.getKey()).getName(), (CacheState)e.getValue());
        }
        GlobalConfigurationStateListener stateCacheListener = new GlobalConfigurationStateListener(this);
        this.getStateCache().addListener(stateCacheListener, new ScopeFilter(CACHE_SCOPE));
        if (this.globalConfiguration.globalState().enabled()) {
            try (FileInputStream fis2 = new FileInputStream(this.getPersistentFile());){
                ConfigurationBuilderHolder holder = this.parserRegistry.parse(fis2);
                for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                    String name = entry.getKey();
                    Configuration configuration = entry.getValue().build();
                    this.createCache(name, configuration, EnumSet.of(CacheContainerAdmin.AdminFlag.PERSISTENT));
                }
            }
            catch (FileNotFoundException fis2) {
            }
            catch (IOException e) {
                throw new CacheConfigurationException((Exception)e);
            }
        }
    }

    private File getPersistentFile() {
        return new File(this.globalConfiguration.globalState().persistentLocation(), "caches.xml");
    }

    private File getPersistentFileLock() {
        return new File(this.globalConfiguration.globalState().persistentLocation(), "caches.xml.lck");
    }

    public Cache<ScopedState, Object> getStateCache() {
        if (this.stateCache == null) {
            this.stateCache = this.cacheManager.getCache("org.infinispan.CONFIG");
        }
        return this.stateCache;
    }

    private void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERSISTENT) && !this.globalConfiguration.globalState().enabled()) {
            throw log.globalStateDisabled();
        }
    }

    @Override
    public Configuration createCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.validateFlags(flags);
        try {
            CacheState state = new CacheState(this.parserRegistry.serialize(cacheName, configuration), flags);
            this.getStateCache().putIfAbsent(new ScopedState(CACHE_SCOPE, cacheName), state);
            return configuration;
        }
        catch (Exception e) {
            throw log.configurationSerializationFailed(cacheName, configuration, e);
        }
    }

    @Override
    public Configuration createCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration configuration;
        if (template == null) {
            configuration = this.cacheManager.getDefaultCacheConfiguration();
            if (configuration == null) {
                configuration = new ConfigurationBuilder().build();
            }
        } else {
            configuration = this.cacheManager.getCacheConfiguration(template);
            if (configuration == null) {
                throw log.undeclaredConfiguration(cacheName, template);
            }
        }
        return this.createCache(cacheName, configuration, flags);
    }

    void localCreateCache(String name, CacheState state) {
        log.debugf("Create cache %s", name);
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(state.getConfiguration());
        Configuration configuration = builderHolder.getNamedConfigurationBuilders().get(name).build();
        this.localCreateCache(name, configuration, state.getFlags());
    }

    void localCreateCache(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = this.cacheManager.getCacheConfiguration(name);
        if (existing == null) {
            this.cacheManager.defineConfiguration(name, configuration);
            log.debugf("Defined cache '%s' on '%s' using %s", name, this.cacheManager.getAddress(), configuration);
        } else {
            if (!existing.equals(configuration)) {
                throw log.incompatibleClusterConfiguration(name, configuration, existing);
            }
            log.debugf("%s already has a cache %s with configuration %s", this.cacheManager.getAddress(), name, configuration);
        }
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERSISTENT)) {
            this.persistentCaches.add((Object)name);
            this.persistConfigurations();
        }
        this.cacheManager.getCache(name);
    }

    @Override
    public void removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.validateFlags(flags);
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERSISTENT)) {
            this.persistentCaches.remove((Object)name);
            this.persistConfigurations();
        }
        ScopedState cacheScopedState = new ScopedState(CACHE_SCOPE, name);
        if (this.getStateCache().containsKey(cacheScopedState)) {
            this.getStateCache().remove(cacheScopedState);
        } else {
            this.localRemoveCache(name);
        }
    }

    void localRemoveCache(String cacheName) {
        log.debugf("Remove cache %s", cacheName);
        RemoveCacheCommand.removeCache(this.cacheManager, cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistConfigurations() {
        try {
            Object cacheName2;
            File temp = File.createTempFile("caches", null, new File(this.globalConfiguration.globalState().persistentLocation()));
            HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
            for (Object cacheName2 : this.persistentCaches) {
                configurationMap.put((String)cacheName2, this.cacheManager.getCacheConfiguration((String)cacheName2));
            }
            FileOutputStream f = new FileOutputStream(temp);
            cacheName2 = null;
            try {
                this.parserRegistry.serialize((OutputStream)f, null, configurationMap);
            }
            catch (Throwable throwable) {
                cacheName2 = throwable;
                throw throwable;
            }
            finally {
                if (f != null) {
                    if (cacheName2 != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)cacheName2).addSuppressed(throwable);
                        }
                    } else {
                        f.close();
                    }
                }
            }
            FileLock lock = null;
            try (FileOutputStream lockFile = new FileOutputStream(this.getPersistentFileLock());){
                lock = lockFile.getChannel().lock();
                temp.renameTo(this.getPersistentFile());
            }
            finally {
                if (lock != null && lock.isValid()) {
                    lock.release();
                }
                this.getPersistentFileLock().delete();
            }
        }
        catch (Exception e) {
            throw log.errorPersistingGlobalConfiguration(e);
        }
    }
}

