/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.infinispan.Version;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalStateManagerImpl
implements GlobalStateManager {
    public static final String VERSION = "@version";
    public static final String TIMESTAMP = "@timestamp";
    public static final String VERSION_MAJOR = "version-major";
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private GlobalConfiguration globalConfiguration;
    private List<GlobalStateProvider> stateProviders = new ArrayList<GlobalStateProvider>();
    private TimeService timeService;
    private boolean persistentState;

    @Inject
    public void inject(GlobalConfiguration globalConfiguration, TimeService timeService) {
        this.globalConfiguration = globalConfiguration;
        this.timeService = timeService;
        this.persistentState = globalConfiguration.globalState().enabled();
    }

    @Start(priority=1)
    public void start() {
        if (this.persistentState) {
            this.loadGlobalState();
        }
    }

    @Stop(priority=1)
    public void stop() {
        if (this.persistentState) {
            this.writeGlobalState();
        }
    }

    private void loadGlobalState() {
        File stateFile = this.getStateFile("___global");
        Optional<ScopedPersistentState> globalState = this.readScopedState("___global");
        if (globalState.isPresent()) {
            ScopedPersistentState state = globalState.get();
            if (!stateFile.canWrite()) {
                throw log.nonWritableStateFile(stateFile);
            }
            log.globalStateLoad(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
            this.stateProviders.forEach(provider -> provider.prepareForRestore(state));
        } else {
            try {
                stateFile.getParentFile().mkdirs();
                stateFile.createNewFile();
            }
            catch (IOException e) {
                throw log.nonWritableStateFile(stateFile);
            }
        }
    }

    @Override
    public void writeGlobalState() {
        if (this.persistentState) {
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("___global");
            state.setProperty(VERSION, Version.getVersion());
            state.setProperty(VERSION_MAJOR, Version.getMajor());
            state.setProperty(TIMESTAMP, this.timeService.instant().toString());
            this.stateProviders.forEach(provider -> provider.prepareForPersist(state));
            this.writeScopedState(state);
            log.globalStateWrite(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
        }
    }

    @Override
    public void writeScopedState(ScopedPersistentState state) {
        if (this.persistentState) {
            File stateFile = this.getStateFile(state.getScope());
            try (PrintWriter w = new PrintWriter(stateFile);){
                state.forEach((key, value) -> w.printf("%s=%s%n", Util.unicodeEscapeString((String)key), Util.unicodeEscapeString((String)value)));
            }
            catch (IOException e) {
                throw log.failedWritingGlobalState(e, stateFile);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ScopedPersistentState> readScopedState(String scope) {
        if (!this.persistentState) {
            return Optional.empty();
        }
        File stateFile = this.getStateFile(scope);
        if (!stateFile.exists()) {
            return Optional.empty();
        }
        try (BufferedReader r = new BufferedReader(new FileReader(stateFile));){
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(scope);
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    int eq = line.indexOf(61);
                    while (eq > 0 && line.charAt(eq - 1) == '\\') {
                        eq = line.indexOf(61, eq + 1);
                    }
                    if (eq > 0) {
                        state.setProperty(Util.unicodeUnescapeString((String)line.substring(0, eq).trim()), Util.unicodeUnescapeString((String)line.substring(eq + 1).trim()));
                    }
                }
                line = r.readLine();
            }
            Optional<ScopedPersistentState> optional = Optional.of(state);
            return optional;
        }
        catch (IOException e) {
            throw log.failedReadingPersistentState(e, stateFile);
        }
    }

    private File getStateFile(String scope) {
        return new File(this.globalConfiguration.globalState().persistentLocation(), scope + ".state");
    }

    @Override
    public void registerStateProvider(GlobalStateProvider provider) {
        this.stateProviders.add(provider);
    }
}

