/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.Flowable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStream;
import org.infinispan.stream.impl.PriorityMergingProcessor;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.intops.object.DistinctOperation;
import org.infinispan.stream.impl.intops.object.FilterOperation;
import org.infinispan.stream.impl.intops.object.FlatMapOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToIntOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToLongOperation;
import org.infinispan.stream.impl.intops.object.LimitOperation;
import org.infinispan.stream.impl.intops.object.MapOperation;
import org.infinispan.stream.impl.intops.object.MapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.MapToIntOperation;
import org.infinispan.stream.impl.intops.object.MapToLongOperation;
import org.infinispan.stream.impl.intops.object.PeekOperation;
import org.infinispan.stream.impl.termop.object.ForEachBiOperation;
import org.infinispan.stream.impl.termop.object.ForEachOperation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class DistributedCacheStream<R>
extends AbstractCacheStream<R, Stream<R>, CacheStream<R>>
implements CacheStream<R> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    protected static Supplier<CacheStream<CacheEntry>> supplierStreamCast(Supplier supplier) {
        return supplier;
    }

    public <K, V> DistributedCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<CacheEntry<K, V>>> supplier, ClusterStreamManager csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry) {
        super(localAddress, parallel, dm, DistributedCacheStream.supplierStreamCast(supplier), csm, includeLoader, distributedBatchSize, executor, registry);
    }

    public <K, V> DistributedCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<CacheEntry<K, V>>> supplier, ClusterStreamManager csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry, Function<? super CacheEntry<K, V>, R> function) {
        super(localAddress, parallel, dm, DistributedCacheStream.supplierStreamCast(supplier), csm, includeLoader, distributedBatchSize, executor, registry);
        this.intermediateOperations.add(new MapOperation<CacheEntry<K, V>, R>(function));
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
    }

    protected DistributedCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected CacheStream<R> unwrap() {
        return this;
    }

    @Override
    public CacheStream<R> filter(Predicate<? super R> predicate) {
        return (CacheStream)this.addIntermediateOperation(new FilterOperation<R>(predicate));
    }

    @Override
    public <R1> CacheStream<R1> map(Function<? super R, ? extends R1> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        this.addIntermediateOperationMap(new MapOperation<R, R1>(mapper));
        return this;
    }

    @Override
    public IntCacheStream mapToInt(ToIntFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        this.addIntermediateOperationMap(new MapToIntOperation<R>(mapper));
        return this.intCacheStream();
    }

    @Override
    public LongCacheStream mapToLong(ToLongFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        this.addIntermediateOperationMap(new MapToLongOperation<R>(mapper));
        return this.longCacheStream();
    }

    @Override
    public DoubleCacheStream mapToDouble(ToDoubleFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        this.addIntermediateOperationMap(new MapToDoubleOperation<R>(mapper));
        return this.doubleCacheStream();
    }

    @Override
    public <R1> CacheStream<R1> flatMap(Function<? super R, ? extends Stream<? extends R1>> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        this.addIntermediateOperationMap(new FlatMapOperation(mapper));
        return this;
    }

    @Override
    public IntCacheStream flatMapToInt(Function<? super R, ? extends IntStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        this.addIntermediateOperationMap(new FlatMapToIntOperation<R>(mapper));
        return this.intCacheStream();
    }

    @Override
    public LongCacheStream flatMapToLong(Function<? super R, ? extends LongStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        this.addIntermediateOperationMap(new FlatMapToLongOperation<R>(mapper));
        return this.longCacheStream();
    }

    @Override
    public DoubleCacheStream flatMapToDouble(Function<? super R, ? extends DoubleStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        this.addIntermediateOperationMap(new FlatMapToDoubleOperation<R>(mapper));
        return this.doubleCacheStream();
    }

    @Override
    public CacheStream<R> distinct() {
        this.addIntermediateOperation(DistinctOperation.getInstance());
        return new IntermediateCacheStream(this).distinct();
    }

    @Override
    public CacheStream<R> sorted() {
        return new IntermediateCacheStream(this).sorted();
    }

    @Override
    public CacheStream<R> sorted(Comparator<? super R> comparator) {
        return new IntermediateCacheStream(this).sorted((Comparator)comparator);
    }

    @Override
    public CacheStream<R> peek(Consumer<? super R> action) {
        return (CacheStream)this.addIntermediateOperation(new PeekOperation<R>(action));
    }

    @Override
    public CacheStream<R> limit(long maxSize) {
        this.addIntermediateOperation(new LimitOperation(maxSize));
        return new IntermediateCacheStream(this).limit(maxSize);
    }

    @Override
    public CacheStream<R> skip(long n) {
        return new IntermediateCacheStream(this).skip(n);
    }

    @Override
    public R reduce(R identity, BinaryOperator<R> accumulator) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, accumulator), true, accumulator, null);
    }

    @Override
    public Optional<R> reduce(BinaryOperator<R> accumulator) {
        R value = this.performOperation(TerminalFunctions.reduceFunction(accumulator), true, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return accumulator.apply(e1, e2);
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super R, U> accumulator, BinaryOperator<U> combiner) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, accumulator, combiner), true, combiner, null);
    }

    @Override
    public <R1> R1 collect(Supplier<R1> supplier, BiConsumer<R1, ? super R> accumulator, BiConsumer<R1, R1> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public <R1, A> R1 collect(Collector<? super R, A, R1> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return this.performOperation(TerminalFunctions.collectorFunction(collector), true, collector.combiner(), null);
        }
        Object intermediateResult = this.performOperation(TerminalFunctions.collectorFunction(new IdentifyFinishCollector<R, A>(collector)), true, collector.combiner(), null);
        return collector.finisher().apply(intermediateResult);
    }

    @Override
    public Optional<R> min(Comparator<? super R> comparator) {
        R value = this.performOperation(TerminalFunctions.minFunction(comparator), false, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return comparator.compare((Object)e1, (Object)e2) > 0 ? e2 : e1;
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<R> max(Comparator<? super R> comparator) {
        R value = this.performOperation(TerminalFunctions.maxFunction(comparator), false, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return comparator.compare((Object)e1, (Object)e2) > 0 ? e1 : e2;
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean anyMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean allMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public Optional<R> findFirst() {
        return this.findAny();
    }

    @Override
    public Optional<R> findAny() {
        Object value = this.performOperation(TerminalFunctions.findAnyFunction(), false, (r1, r2) -> r1 == null ? r2 : r1, Objects::nonNull);
        return Optional.ofNullable(value);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countFunction(), true, (l1, l2) -> l1 + l2, null);
    }

    @Override
    public Iterator<R> iterator() {
        log.tracef("Distributed iterator invoked with rehash: %s", this.rehashAware);
        if (!this.rehashAware) {
            CloseableIterator closeableIterator = this.nonRehashRemoteIterator(this.segmentsToFilter, null, IdentityPublisherDecorator.getInstance(), this.intermediateOperations);
            this.onClose(() -> closeableIterator.close());
            return closeableIterator;
        }
        Iterable<IntermediateOperation> ops = this.iteratorOperation.prepareForIteration(this.intermediateOperations);
        RehashIterator closeableIterator = this.segmentCompletionListener != null && this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP ? new CompletionListenerRehashIterator(ops, this.segmentCompletionListener) : new RehashIterator(ops);
        this.onClose(() -> closeableIterator.close());
        Function function = this.iteratorOperation.getFunction();
        if (function != null) {
            return new IteratorMapper(closeableIterator, function);
        }
        return closeableIterator;
    }

    <S> Publisher<S> localPublisher(IntSet segmentsToFilter, ConsistentHash ch, Set<Object> excludedKeys, Iterable<IntermediateOperation> intermediateOperations, boolean stayLocal) {
        Supplier<Stream<CacheEntry>> supplier = this.supplierForSegments(ch, segmentsToFilter, excludedKeys, stayLocal);
        BaseStream stream = supplier.get();
        for (IntermediateOperation intermediateOperation : intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        BaseStream innerStream = stream;
        return Flowable.fromIterable(() -> innerStream.iterator());
    }

    <S> CloseableIterator<S> nonRehashRemoteIterator(IntSet segmentsToFilter, IntFunction<Set<Object>> keysToExclude, PublisherDecorator<S> publisherFunction, Iterable<IntermediateOperation> intermediateOperations) {
        Publisher<S> localPublisher;
        boolean stayLocal;
        ConsistentHash ch = this.dm.getReadConsistentHash();
        if (ch.getMembers().contains(this.localAddress)) {
            Set<Integer> ownedSegments = ch.getSegmentsForOwner(this.localAddress);
            stayLocal = segmentsToFilter == null ? ownedSegments.size() == ch.getNumSegments() : ownedSegments.containsAll((Collection<?>)segmentsToFilter);
            Publisher<S> innerPublisher = this.localPublisher(segmentsToFilter, ch, keysToExclude == null ? Collections.emptySet() : (segmentsToFilter == null ? IntStream.range(0, ch.getNumSegments()) : segmentsToFilter.intStream()).mapToObj(i -> ((Set)keysToExclude.apply(i)).stream()).flatMap(Function.identity()).collect(Collectors.toSet()), intermediateOperations, !stayLocal);
            localPublisher = publisherFunction.decorateLocal(ch, stayLocal, segmentsToFilter, innerPublisher);
        } else {
            stayLocal = false;
            localPublisher = Flowable.empty();
        }
        if (stayLocal) {
            return Closeables.iterator(Flowable.fromPublisher((Publisher)localPublisher).blockingIterable().iterator());
        }
        Map<Address, IntSet> targets = this.determineTargets(ch, segmentsToFilter);
        Iterator<Map.Entry<Address, IntSet>> targetIter = targets.entrySet().iterator();
        if (this.parallelDistribution == Boolean.FALSE) {
            Supplier<Map.Entry<Address, IntSet>> supplier = () -> targetIter.hasNext() ? (Map.Entry)targetIter.next() : null;
            ClusterStreamManager.RemoteIteratorPublisher remotePublisher = this.csm.remoteIterationPublisher(false, supplier, this.keysToFilter, keysToExclude, this.includeLoader, intermediateOperations);
            Publisher<S> publisher = publisherFunction.decorateRemote(remotePublisher);
            return PriorityMergingProcessor.build(publisher, this.distributedBatchSize, localPublisher, 64).iterator();
        }
        Supplier<Map.Entry<Address, IntSet>> supplier = () -> {
            DistributedCacheStream distributedCacheStream = this;
            synchronized (distributedCacheStream) {
                return targetIter.hasNext() ? (Map.Entry)targetIter.next() : null;
            }
        };
        PriorityMergingProcessor.Builder<S> builder = PriorityMergingProcessor.builder();
        for (int i2 = 0; i2 < 4 && i2 < targets.size(); ++i2) {
            ClusterStreamManager.RemoteIteratorPublisher remotePublisher = this.csm.remoteIterationPublisher(false, supplier, this.keysToFilter, keysToExclude, this.includeLoader, intermediateOperations);
            Publisher<S> publisher = publisherFunction.decorateRemote(remotePublisher);
            builder.addPublisher(publisher, this.distributedBatchSize);
        }
        return builder.addPublisher(localPublisher, 64).build().iterator();
    }

    private Map<Address, IntSet> determineTargets(ConsistentHash ch, IntSet segments) {
        if (segments == null) {
            segments = new RangeSet(ch.getNumSegments());
        }
        HashMap<Address, IntSet> targets = new HashMap<Address, IntSet>();
        PrimitiveIterator.OfInt segmentIterator = segments.iterator();
        while (segmentIterator.hasNext()) {
            int segment = segmentIterator.nextInt();
            Address owner = ch.locatePrimaryOwnerForSegment(segment);
            if (owner == null || owner.equals(this.localAddress)) continue;
            IntSet targetSegments = (IntSet)targets.get(owner);
            if (targetSegments == null) {
                targetSegments = new SmallIntSet();
                targets.put(owner, targetSegments);
            }
            targetSegments.set(segment);
        }
        return targets;
    }

    @Override
    public Spliterator<R> spliterator() {
        return Spliterators.spliterator(this.iterator(), Long.MAX_VALUE, 4096);
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> new ForEachOperation(this.intermediateOperations, (Supplier<Stream<CacheEntry>>)s, this.distributedBatchSize, action));
        }
    }

    @Override
    public <K, V> void forEach(BiConsumer<Cache<K, V>, ? super R> action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> new ForEachBiOperation(this.intermediateOperations, (Supplier<Stream<CacheEntry>>)s, this.distributedBatchSize, action));
        }
    }

    @Override
    public void forEachOrdered(Consumer<? super R> action) {
        this.forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayFunction(), false, (v1, v2) -> {
            Object[] array = Arrays.copyOf(v1, ((Object[])v1).length + ((Object[])v2).length);
            System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
            return array;
        }, null);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.performOperation(TerminalFunctions.toArrayFunction(generator), false, (v1, v2) -> {
            Object[] array = (Object[])generator.apply(((Object[])v1).length + ((Object[])v2).length);
            System.arraycopy(v1, 0, array, 0, ((Object[])v1).length);
            System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
            return array;
        }, null);
    }

    @Override
    public CacheStream<R> sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public CacheStream<R> parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public CacheStream<R> filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = SmallIntSet.from(segments);
        return this;
    }

    @Override
    public CacheStream<R> filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public CacheStream<R> distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public CacheStream<R> segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public CacheStream<R> disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    @Override
    public CacheStream<R> timeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected DistributedIntCacheStream intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    private class KeyWatchingCompletionListener {
        private final AtomicReference<Object> currentKey = new AtomicReference();
        private final Map<Object, Supplier<PrimitiveIterator.OfInt>> pendingSegments = new ConcurrentHashMap<Object, Supplier<PrimitiveIterator.OfInt>>();
        private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> completionListener;
        private final ByRef<Supplier<PrimitiveIterator.OfInt>> ref = new ByRef(null);
        private final BiFunction<Object, Supplier<PrimitiveIterator.OfInt>, Supplier<PrimitiveIterator.OfInt>> iteratorMapping;

        private KeyWatchingCompletionListener(Consumer<? super Supplier<PrimitiveIterator.OfInt>> completionListener) {
            this.completionListener = completionListener;
            this.iteratorMapping = (k, v) -> {
                if (v != null) {
                    this.ref.set(v);
                }
                this.currentKey.compareAndSet(k, null);
                return null;
            };
        }

        public void valueAdded(Object key) {
            this.currentKey.set(key);
        }

        public void valueIterated(Object key) {
            this.pendingSegments.compute(key, this.iteratorMapping);
            if (this.ref.get() != null) {
                this.completionListener.accept((Supplier<PrimitiveIterator.OfInt>)this.ref.get());
            }
        }

        private IntStream toStream(PrimitiveIterator.OfInt iter) {
            return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(iter, 257), false);
        }

        public void segmentsEncountered(Supplier<PrimitiveIterator.OfInt> segments) {
            AtomicBoolean shouldNotify = new AtomicBoolean(true);
            Object key = this.currentKey.get();
            if (key != null) {
                this.pendingSegments.compute(key, (k, v) -> {
                    if (this.currentKey.get() == null) {
                        return null;
                    }
                    shouldNotify.set(false);
                    if (v == null) {
                        return segments;
                    }
                    return () -> this.lambda$null$2((Supplier)segments, (Supplier)v);
                });
            }
            if (shouldNotify.get()) {
                this.completionListener.accept(segments);
            }
        }

        public void completed() {
            this.pendingSegments.forEach((k, v) -> this.completionListener.accept((Supplier<PrimitiveIterator.OfInt>)v));
        }

        private /* synthetic */ PrimitiveIterator.OfInt lambda$null$2(Supplier segments, Supplier v) {
            return Stream.of(segments, v).flatMapToInt(s -> this.toStream((PrimitiveIterator.OfInt)s.get())).iterator();
        }
    }

    private class CompletionListenerRehashIterator<S>
    extends RehashIterator<S> {
        private final KeyWatchingCompletionListener completionListener;

        private CompletionListenerRehashIterator(Iterable<IntermediateOperation> intermediateOperations, Consumer<? super Supplier<PrimitiveIterator.OfInt>> completionListener) {
            super(intermediateOperations);
            this.completionListener = new KeyWatchingCompletionListener(completionListener);
        }

        @Override
        protected S getNext() {
            Object next = super.getNext();
            if (next != null) {
                this.completionListener.valueIterated(next);
            } else {
                this.completionListener.completed();
            }
            return next;
        }

        @Override
        PublisherDecorator<S> publisherDecorator(Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments, Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments, Consumer<Object> keyConsumer) {
            Consumer<Supplier> ourCompleted = i -> {
                this.completionListener.segmentsEncountered((Supplier<PrimitiveIterator.OfInt>)i);
                completedSegments.accept((Supplier<PrimitiveIterator.OfInt>)i);
            };
            return new RehashPublisherDecorator<S>(ourCompleted, lostSegments, keyConsumer){

                @Override
                protected Publisher<S> decorateBeforeReturn(Publisher<S> publisher) {
                    return Flowable.fromPublisher(super.decorateBeforeReturn(publisher)).doOnNext(CompletionListenerRehashIterator.this.completionListener::valueAdded);
                }
            };
        }
    }

    private class RehashIterator<S>
    extends AbstractIterator<S>
    implements CloseableIterator<S> {
        private final AtomicReferenceArray<Set<Object>> receivedKeys;
        private final Iterable<IntermediateOperation> intermediateOperations;
        private final IntSet segmentsToUse;
        private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedHandler;
        private CloseableIterator<S> currentIterator;

        private RehashIterator(Iterable<IntermediateOperation> intermediateOperations) {
            int i;
            this.intermediateOperations = intermediateOperations;
            int maxSegment = DistributedCacheStream.this.dm.getCacheTopology().getCurrentCH().getNumSegments();
            if (DistributedCacheStream.this.segmentsToFilter == null) {
                this.segmentsToUse = new SmallIntSet(maxSegment);
                for (i = 0; i < maxSegment; ++i) {
                    this.segmentsToUse.set(i);
                }
            } else {
                this.segmentsToUse = new SmallIntSet(DistributedCacheStream.this.segmentsToFilter);
            }
            this.receivedKeys = new AtomicReferenceArray(maxSegment);
            for (i = 0; i < this.receivedKeys.length(); ++i) {
                this.receivedKeys.set(i, new HashSet());
            }
            this.completedHandler = completed -> {
                SmallIntSet intSet = log.isTraceEnabled() ? new SmallIntSet() : null;
                ((PrimitiveIterator.OfInt)completed.get()).forEachRemaining(arg_0 -> this.lambda$null$0((IntSet)intSet, arg_0));
                if (intSet != null) {
                    log.tracef("Remote rehash iterator completed segments %s", intSet);
                }
            };
        }

        protected S getNext() {
            do {
                if (this.currentIterator == null) {
                    log.tracef("Creating rehash iterator for segments %s", this.segmentsToUse);
                    this.currentIterator = DistributedCacheStream.this.nonRehashRemoteIterator(this.segmentsToUse, this.receivedKeys::get, this.publisherDecorator(this.completedHandler, lostSegments -> {}, k -> {
                        Set<Object> set = this.receivedKeys.get(DistributedCacheStream.this.keyPartitioner.getSegment(k));
                        if (set != null) {
                            set.add(k);
                        }
                    }), this.intermediateOperations);
                }
                if (this.currentIterator.hasNext()) {
                    return (S)this.currentIterator.next();
                }
                this.currentIterator = null;
            } while (!this.segmentsToUse.isEmpty());
            return null;
        }

        PublisherDecorator<S> publisherDecorator(Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments, Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments, Consumer<Object> keyConsumer) {
            return new RehashPublisherDecorator(completedSegments, lostSegments, keyConsumer);
        }

        public void close() {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ void lambda$null$0(IntSet intSet, int i) {
            this.receivedKeys.set(i, null);
            if (intSet != null) {
                intSet.set(i);
            }
            IntSet intSet2 = this.segmentsToUse;
            synchronized (intSet2) {
                this.segmentsToUse.remove(i);
            }
        }
    }

    private class RehashPublisherDecorator<S>
    implements PublisherDecorator<S> {
        private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments;
        private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments;
        private final Consumer<Object> keyConsumer;

        RehashPublisherDecorator(Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments, Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments, Consumer<Object> keyConsumer) {
            this.completedSegments = completedSegments;
            this.lostSegments = lostSegments;
            this.keyConsumer = keyConsumer;
        }

        @Override
        public Publisher<S> decorateRemote(ClusterStreamManager.RemoteIteratorPublisher<S> remotePublisher) {
            Publisher convertedPublisher = s -> remotePublisher.subscribe(s, this.completedSegments, this.lostSegments);
            return this.decorateBeforeReturn(convertedPublisher);
        }

        @Override
        public Publisher<S> decorateLocal(ConsistentHash beginningCh, boolean onlyLocal, IntSet segmentsToFilter, Publisher<S> localPublisher) {
            Flowable convertedPublisher = Flowable.fromPublisher(localPublisher).doOnComplete(() -> {
                SmallIntSet ourSegments = onlyLocal ? SmallIntSet.from(beginningCh.getSegmentsForOwner(DistributedCacheStream.this.localAddress)) : SmallIntSet.from(beginningCh.getPrimarySegmentsForOwner(DistributedCacheStream.this.localAddress));
                ourSegments.retainAll(segmentsToFilter);
                if (DistributedCacheStream.this.dm.getReadConsistentHash().equals(beginningCh)) {
                    log.tracef("Local iterator has completed segments %s", ourSegments);
                    this.completedSegments.accept(() -> ((IntSet)ourSegments).iterator());
                } else {
                    log.tracef("Local iterator segments %s are all suspect as consistent hash has changed", ourSegments);
                    this.lostSegments.accept(() -> ((IntSet)ourSegments).iterator());
                }
            });
            return this.decorateBeforeReturn((Publisher<S>)convertedPublisher);
        }

        protected Publisher<S> decorateBeforeReturn(Publisher<S> publisher) {
            return DistributedCacheStream.this.iteratorOperation.handlePublisher(publisher, this.keyConsumer);
        }
    }

    private static class IdentityPublisherDecorator<S, R>
    implements PublisherDecorator<S> {
        private static final IdentityPublisherDecorator decorator = new IdentityPublisherDecorator();

        private IdentityPublisherDecorator() {
        }

        static <S, R> IdentityPublisherDecorator<S, R> getInstance() {
            return decorator;
        }

        @Override
        public Publisher<S> decorateRemote(ClusterStreamManager.RemoteIteratorPublisher<S> remotePublisher) {
            return remotePublisher;
        }

        @Override
        public Publisher<S> decorateLocal(ConsistentHash beginningCh, boolean onlyLocal, IntSet segmentsToFilter, Publisher<S> localPublisher) {
            return localPublisher;
        }
    }

    static interface PublisherDecorator<S> {
        public Publisher<S> decorateRemote(ClusterStreamManager.RemoteIteratorPublisher<S> var1);

        public Publisher<S> decorateLocal(ConsistentHash var1, boolean var2, IntSet var3, Publisher<S> var4);
    }

    @SerializeWith(value=IdentityFinishCollectorExternalizer.class)
    private static final class IdentifyFinishCollector<T, A>
    implements Collector<T, A, A> {
        private final Collector<T, A, ?> realCollector;

        IdentifyFinishCollector(Collector<T, A, ?> realCollector) {
            this.realCollector = realCollector;
        }

        @Override
        public Supplier<A> supplier() {
            return this.realCollector.supplier();
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.realCollector.accumulator();
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.realCollector.combiner();
        }

        @Override
        public Function<A, A> finisher() {
            return null;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            Set<Collector.Characteristics> characteristics = this.realCollector.characteristics();
            if (characteristics.size() == 0) {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
            EnumSet<Collector.Characteristics> tweaked = EnumSet.copyOf(characteristics);
            tweaked.add(Collector.Characteristics.IDENTITY_FINISH);
            return tweaked;
        }

        public static final class IdentityFinishCollectorExternalizer
        implements Externalizer<IdentifyFinishCollector> {
            public void writeObject(ObjectOutput output, IdentifyFinishCollector object) throws IOException {
                output.writeObject(object.realCollector);
            }

            public IdentifyFinishCollector readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new IdentifyFinishCollector((Collector)input.readObject());
            }
        }
    }
}

