/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RemovableCloseableIterator;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.context.Flag;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeyStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> {
    private static final Log log = LogFactory.getLog(KeyStreamSupplier.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final ToIntFunction<Object> toIntFunction;
    private final Supplier<Stream<K>> supplier;

    public KeyStreamSupplier(Cache<K, V> cache, ToIntFunction<Object> toIntFunction, Supplier<Stream<K>> supplier) {
        this.cache = cache;
        this.toIntFunction = toIntFunction;
        this.supplier = supplier;
    }

    @Override
    public Stream<K> buildStream(Set<Integer> segmentsToFilter, Set<?> keysToFilter) {
        Stream<Object> stream;
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            stream = keysToFilter.stream().filter(arg_0 -> advancedCache.containsKey(arg_0));
        } else {
            stream = this.supplier.get();
        }
        if (segmentsToFilter != null && this.toIntFunction != null) {
            if (trace) {
                log.tracef("Applying segment filter %s", segmentsToFilter);
            }
            SmallIntSet intSet = SmallIntSet.from(segmentsToFilter);
            stream = stream.filter(arg_0 -> this.lambda$buildStream$0((IntSet)intSet, arg_0));
        }
        return stream;
    }

    @Override
    public CloseableIterator<K> removableIterator(CloseableIterator<K> realIterator) {
        return new RemovableCloseableIterator(realIterator, arg_0 -> this.cache.remove(arg_0));
    }

    private /* synthetic */ boolean lambda$buildStream$0(IntSet intSet, Object k) {
        return intSet.contains(this.toIntFunction.applyAsInt(k));
    }
}

