/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.rest.InfinispanErrorResponse;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.operations.CacheOperations;
import org.infinispan.rest.operations.StaticContent;

public class InfinispanCacheAPIRequest
extends InfinispanRequest {
    private final Optional<String> key;
    private final CacheOperations cacheOperations;

    InfinispanCacheAPIRequest(CacheOperations operations, FullHttpRequest request, ChannelHandlerContext ctx, Optional<String> cacheName, Optional<String> key, String context, Map<String, List<String>> parameters) {
        super(request, ctx, cacheName.orElse(null), context, parameters);
        this.cacheOperations = operations;
        this.key = key;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    @Override
    protected InfinispanResponse execute() {
        InfinispanResponse response = InfinispanErrorResponse.asError(this, HttpResponseStatus.NOT_IMPLEMENTED, null);
        if (this.request.method() == HttpMethod.GET) {
            response = this.request.uri().endsWith("banner.png") ? StaticContent.INSTANCE.serveBannerFile(this) : (!this.getCacheName().isPresent() ? StaticContent.INSTANCE.serveHtmlFile(this) : (!this.key.isPresent() ? this.cacheOperations.getCacheValues(this) : this.cacheOperations.getCacheValue(this)));
        } else if (this.request.method() == HttpMethod.POST || this.request.method() == HttpMethod.PUT) {
            response = this.cacheOperations.putValueToCache(this);
        } else if (this.request.method() == HttpMethod.HEAD) {
            response = this.cacheOperations.getCacheValue(this);
        } else if (this.request.method() == HttpMethod.DELETE) {
            response = !this.key.isPresent() ? this.cacheOperations.clearEntireCache(this) : this.cacheOperations.deleteCacheValue(this);
        }
        return response;
    }

    public Optional<Long> getTimeToLiveSeconds() {
        String timeToLiveSeconds = this.request.headers().get("timeToLiveSeconds");
        if (timeToLiveSeconds != null) {
            try {
                return Optional.of(Long.valueOf(timeToLiveSeconds));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<Long> getMaxIdleTimeSeconds() {
        String maxIdleTimeSeconds = this.request.headers().get("maxIdleTimeSeconds");
        if (maxIdleTimeSeconds != null) {
            try {
                return Optional.of(Long.valueOf(maxIdleTimeSeconds));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<String> getEtagIfNoneMatch() {
        return Optional.ofNullable(this.request.headers().get("If-None-Match"));
    }

    public Optional<String> getEtagIfUnmodifiedSince() {
        return Optional.ofNullable(this.request.headers().get("If-Unmodified-Since"));
    }

    public Optional<String> getEtagIfModifiedSince() {
        return Optional.ofNullable(this.request.headers().get("If-Modified-Since"));
    }

    public Optional<String> getEtagIfMatch() {
        return Optional.ofNullable(this.request.headers().get("If-Match"));
    }

    public Optional<String> getCacheControl() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.CACHE_CONTROL));
    }

    public Optional<String> getExtended() {
        List extendedParameters = (List)this.parameters.get("extended");
        if (extendedParameters != null && extendedParameters.size() > 0) {
            return Optional.ofNullable(extendedParameters.get(0));
        }
        return Optional.empty();
    }
}

