/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.rest.InfinispanResponse;

public abstract class InfinispanRequest {
    protected final FullHttpRequest request;
    private final Optional<String> streamId;
    private final ChannelHandlerContext nettyChannelContext;
    private final String cacheName;
    private final String context;
    protected Map<String, List<String>> parameters;

    protected InfinispanRequest(FullHttpRequest request, ChannelHandlerContext ctx, String cacheName, String context, Map<String, List<String>> parameters) {
        this.request = request;
        this.streamId = Optional.ofNullable(request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()));
        this.nettyChannelContext = ctx;
        this.cacheName = cacheName;
        this.context = context;
        this.parameters = parameters;
    }

    protected abstract InfinispanResponse execute();

    public Optional<String> getCacheName() {
        return Optional.ofNullable(this.cacheName);
    }

    Optional<String> getStreamId() {
        return this.streamId;
    }

    public FullHttpRequest getRawRequest() {
        return this.request;
    }

    public ChannelHandlerContext getRawContext() {
        return this.nettyChannelContext;
    }

    public Optional<Boolean> getUseAsync() {
        String performAsync = this.request.headers().get("performAsync");
        if ("true".equals(performAsync)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> getAcceptContentType() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.request.headers().get("Content-type"));
    }

    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
    }

    public String getContext() {
        return this.context;
    }

    public Optional<byte[]> data() {
        if (this.request.content() != null) {
            ByteBuf content = this.request.content();
            if (content.hasArray()) {
                return Optional.of(content.array());
            }
            byte[] bufferCopy = new byte[content.readableBytes()];
            content.readBytes(bufferCopy);
            return Optional.of(bufferCopy);
        }
        return Optional.empty();
    }

    protected String getParameterValue(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.iterator().next();
    }
}

