/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.rest.dataconversion.TextObjectTranscoder;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TextBinaryTranscoder
implements Transcoder {
    protected static final Log logger = (Log)LogFactory.getLog(TextObjectTranscoder.class, Log.class);
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();

    public TextBinaryTranscoder() {
        supportedTypes.add(MediaType.TEXT_PLAIN);
        supportedTypes.add(MediaType.APPLICATION_OCTET_STREAM);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            if (content instanceof String) {
                return ((String)content).getBytes(StandardCharsets.UTF_8);
            }
            if (content instanceof byte[]) {
                return content;
            }
            throw logger.invalidTextFormat(content);
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            if (!(content instanceof byte[])) {
                throw logger.invalidBinaryFormat(content);
            }
            return Base64.getEncoder().encodeToString((byte[])content);
        }
        return null;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }
}

