/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionRegistryBuilder;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneCompositeAnalysisDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneNormalizerDefinitionContext;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalyzerDefinitionContextImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneNormalizerDefinitionContextImpl;
import org.hibernate.search.analyzer.definition.impl.SimpleLuceneAnalysisDefinitionRegistry;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneAnalysisDefinitionRegistryBuilderImpl
implements LuceneAnalysisDefinitionRegistryBuilder {
    private static final Log LOG = LoggerFactory.make();
    private Map<String, LuceneAnalyzerDefinitionContextImpl> analyzerDefinitions = new LinkedHashMap<String, LuceneAnalyzerDefinitionContextImpl>();
    private Map<String, LuceneNormalizerDefinitionContextImpl> normalizerDefinitions = new LinkedHashMap<String, LuceneNormalizerDefinitionContextImpl>();

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(String name) {
        LuceneAnalyzerDefinitionContextImpl definition = new LuceneAnalyzerDefinitionContextImpl(this, name);
        LuceneAnalyzerDefinitionContextImpl existing = this.analyzerDefinitions.putIfAbsent(name, definition);
        if (existing != null) {
            throw LOG.analyzerDefinitionNamingConflict(name);
        }
        return definition;
    }

    @Override
    public LuceneNormalizerDefinitionContext normalizer(String name) {
        LuceneNormalizerDefinitionContextImpl definition = new LuceneNormalizerDefinitionContextImpl(this, name);
        LuceneNormalizerDefinitionContextImpl existing = this.normalizerDefinitions.putIfAbsent(name, definition);
        if (existing != null) {
            throw LOG.normalizerDefinitionNamingConflict(name);
        }
        return definition;
    }

    public SimpleLuceneAnalysisDefinitionRegistry build() {
        SimpleLuceneAnalysisDefinitionRegistry registry = new SimpleLuceneAnalysisDefinitionRegistry();
        for (Map.Entry<String, LuceneAnalyzerDefinitionContextImpl> entry : this.analyzerDefinitions.entrySet()) {
            registry.register(entry.getKey(), entry.getValue().build());
        }
        for (Map.Entry<String, LuceneCompositeAnalysisDefinitionContext> entry : this.normalizerDefinitions.entrySet()) {
            registry.register(entry.getKey(), ((LuceneNormalizerDefinitionContextImpl)entry.getValue()).build());
        }
        return registry;
    }
}

