/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ByTermDeleteWorkExecutor
extends DeleteWorkExecutor {
    private static final Log log = LoggerFactory.make();

    ByTermDeleteWorkExecutor(Workspace workspace) {
        super(workspace);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        IndexedTypeIdentifier managedType = work.getEntityType();
        String tenantId = work.getTenantId();
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(managedType);
        Serializable id = work.getId();
        log.tracef("Removing %s#%s by id using an IndexWriter.", managedType, id);
        try {
            if (tenantId == null) {
                this.deleteWithoutTenant(work, delegate, builder, id);
            } else {
                this.deleteWithTenant(work, delegate, tenantId, builder, id);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to remove " + managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    private void deleteWithTenant(LuceneWork work, IndexWriterDelegate delegate, String tenantId, DocumentBuilderIndexedEntity builder, Serializable id) throws IOException {
        BooleanQuery.Builder termDeleteQueryBuilder = new BooleanQuery.Builder();
        TermQuery tenantTermQuery = new TermQuery(new Term("__HSearch_TenantId", tenantId));
        termDeleteQueryBuilder.add((Query)tenantTermQuery, BooleanClause.Occur.FILTER);
        if (ByTermDeleteWorkExecutor.isIdNumeric(builder)) {
            Query exactMatchQuery = NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id);
            termDeleteQueryBuilder.add(exactMatchQuery, BooleanClause.Occur.FILTER);
        } else {
            Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
            termDeleteQueryBuilder.add((Query)new TermQuery(idTerm), BooleanClause.Occur.FILTER);
        }
        BooleanQuery termDeleteQuery = termDeleteQueryBuilder.build();
        delegate.deleteDocuments((Query)termDeleteQuery);
    }

    private void deleteWithoutTenant(LuceneWork work, IndexWriterDelegate delegate, DocumentBuilderIndexedEntity builder, Serializable id) throws IOException {
        if (ByTermDeleteWorkExecutor.isIdNumeric(builder)) {
            delegate.deleteDocuments(NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id));
        } else {
            Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
            delegate.deleteDocuments(idTerm);
        }
    }
}

