/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.HashSetIndexedTypeSet;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;

public final class IndexedTypeSets {
    private static final Set<Collector.Characteristics> CH_UNORDERED = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED));

    private IndexedTypeSets() {
    }

    public static IndexedTypeSet fromClasses(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return IndexedTypeSets.empty();
        }
        return Arrays.stream(classes).filter(c -> c != null).map(PojoIndexedTypeIdentifier::new).collect(IndexedTypeSets.streamCollector());
    }

    public static IndexedTypeSet fromClass(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        return new PojoIndexedTypeIdentifier(clazz).asTypeSet();
    }

    public static IndexedTypeSet empty() {
        return HashSetIndexedTypeSet.EMPTY;
    }

    public static IndexedTypeSet fromIdentifiers(Iterable<IndexedTypeIdentifier> entityTypes) {
        HashSet<IndexedTypeIdentifier> set;
        Objects.requireNonNull(entityTypes);
        if (entityTypes instanceof Set) {
            set = (HashSet<IndexedTypeIdentifier>)entityTypes;
            IndexedTypeSets.fromSafeHashSet(new HashSet<IndexedTypeIdentifier>(set));
        }
        set = new HashSet<IndexedTypeIdentifier>();
        for (IndexedTypeIdentifier iti : entityTypes) {
            set.add(iti);
        }
        return IndexedTypeSets.fromSafeHashSet(set);
    }

    public static IndexedTypeSet fromIdentifiers(IndexedTypeIdentifier ... types) {
        if (types == null || types.length == 0) {
            return IndexedTypeSets.empty();
        }
        if (types.length == 1) {
            return types[0].asTypeSet();
        }
        return Arrays.stream(types).collect(IndexedTypeSets.streamCollector());
    }

    private static IndexedTypeSet fromSafeHashSet(HashSet<IndexedTypeIdentifier> set) {
        if (set.isEmpty()) {
            return IndexedTypeSets.empty();
        }
        if (set.size() == 1) {
            return set.iterator().next().asTypeSet();
        }
        return new HashSetIndexedTypeSet(set);
    }

    public static IndexedTypeSet composite(IndexedTypeSet set, IndexedTypeIdentifier additionalId) {
        return IndexedTypeSets.composite(set, additionalId.asTypeSet());
    }

    public static IndexedTypeSet composite(IndexedTypeSet setA, IndexedTypeSet setB) {
        if (setA.isEmpty()) {
            return setB;
        }
        if (setB.isEmpty()) {
            return setA;
        }
        if (setB.equals(setA)) {
            return setA;
        }
        HashSet<IndexedTypeIdentifier> newSet = new HashSet<IndexedTypeIdentifier>(setA.size() + setB.size());
        setA.forEach(newSet::add);
        setB.forEach(newSet::add);
        return IndexedTypeSets.fromSafeHashSet(newSet);
    }

    public static IndexedTypeSet subtraction(IndexedTypeSet referenceSet, IndexedTypeSet subtraend) {
        if (referenceSet.isEmpty() || subtraend.isEmpty()) {
            return referenceSet;
        }
        HashSetIndexedTypeSet casted = (HashSetIndexedTypeSet)referenceSet;
        Set<IndexedTypeIdentifier> cloned = casted.cloneInternalSet();
        for (IndexedTypeIdentifier toRemove : subtraend) {
            cloned.remove(toRemove);
        }
        if (cloned.isEmpty()) {
            return IndexedTypeSets.empty();
        }
        if (cloned.size() == 1) {
            return cloned.iterator().next().asTypeSet();
        }
        return new HashSetIndexedTypeSet(cloned);
    }

    public static Collector<IndexedTypeIdentifier, ?, IndexedTypeSet> streamCollector() {
        return new Collector<IndexedTypeIdentifier, HashSet<IndexedTypeIdentifier>, IndexedTypeSet>(){

            @Override
            public Supplier<HashSet<IndexedTypeIdentifier>> supplier() {
                return HashSet::new;
            }

            @Override
            public BiConsumer<HashSet<IndexedTypeIdentifier>, IndexedTypeIdentifier> accumulator() {
                return (s, i) -> s.add(i);
            }

            @Override
            public BinaryOperator<HashSet<IndexedTypeIdentifier>> combiner() {
                return (a, b) -> {
                    a.addAll(b);
                    return a;
                };
            }

            @Override
            public Function<HashSet<IndexedTypeIdentifier>, IndexedTypeSet> finisher() {
                return x$0 -> IndexedTypeSets.fromSafeHashSet(x$0);
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CH_UNORDERED;
            }
        };
    }
}

