/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex.be;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.EqualsCondition;
import org.infinispan.objectfilter.impl.predicateindex.IntervalPredicate;
import org.infinispan.objectfilter.impl.predicateindex.IsNullCondition;
import org.infinispan.objectfilter.impl.predicateindex.LikeCondition;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.be.AndNode;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.OrNode;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.util.Interval;

public final class BETreeMaker<AttributeId extends Comparable<AttributeId>> {
    private final MetadataAdapter<?, ?, AttributeId> metadataAdapter;
    private final boolean useIntervals;

    public BETreeMaker(MetadataAdapter<?, ?, AttributeId> metadataAdapter, boolean useIntervals) {
        this.metadataAdapter = metadataAdapter;
        this.useIntervals = useIntervals;
    }

    public BETree make(BooleanExpr booleanExpr, Map<String, Object> namedParameters) {
        ArrayList<BENode> nodes = new ArrayList<BENode>();
        ArrayList<Integer> treeCounters = new ArrayList<Integer>();
        if (booleanExpr == null) {
            treeCounters.add(0);
        } else if (booleanExpr instanceof ConstantBooleanExpr) {
            treeCounters.add(((ConstantBooleanExpr)booleanExpr).getValue() ? 0 : -1);
        } else {
            this.preorderTraversal(null, booleanExpr, nodes, treeCounters, namedParameters);
        }
        int[] countersArray = new int[treeCounters.size()];
        for (int i = 0; i < countersArray.length; ++i) {
            countersArray[i] = (Integer)treeCounters.get(i);
        }
        return new BETree(nodes.toArray(new BENode[nodes.size()]), countersArray);
    }

    private void preorderTraversal(BENode parent, BooleanExpr child, List<BENode> nodes, List<Integer> treeCounters, Map<String, Object> namedParameters) {
        if (child instanceof NotExpr) {
            PrimaryPredicateExpr condition = (PrimaryPredicateExpr)((NotExpr)child).getChild();
            this.makePredicateNode(parent, nodes, treeCounters, condition, true, namedParameters);
        } else if (child instanceof PrimaryPredicateExpr) {
            PrimaryPredicateExpr condition = (PrimaryPredicateExpr)child;
            this.makePredicateNode(parent, nodes, treeCounters, condition, false, namedParameters);
        } else if (child instanceof OrExpr) {
            this.makeBooleanOperatorNode((OrExpr)child, nodes, treeCounters, new OrNode(parent), namedParameters);
        } else if (child instanceof AndExpr) {
            this.makeBooleanOperatorNode((AndExpr)child, nodes, treeCounters, new AndNode(parent), namedParameters);
        } else {
            throw new IllegalStateException("Unexpected *Expr node type: " + child);
        }
    }

    private void makePredicateNode(BENode parent, List<BENode> nodes, List<Integer> treeCounters, PrimaryPredicateExpr condition, boolean isNegated, Map<String, Object> namedParameters) {
        PropertyValueExpr pve = (PropertyValueExpr)condition.getChild();
        List<AttributeId> path = this.metadataAdapter.mapPropertyNamePathToFieldIdPath(pve.getPropertyPath().asArrayPath());
        boolean isRepeated = pve.isRepeated();
        if (condition instanceof ComparisonExpr) {
            ComparisonExpr expr = (ComparisonExpr)condition;
            ConstantValueExpr right = (ConstantValueExpr)expr.getRightChild();
            Comparable rightConstant = right.getConstantValueAs(pve.getPrimitiveType(), namedParameters);
            switch (expr.getComparisonType()) {
                case NOT_EQUAL: {
                    if (this.useIntervals) {
                        if (!(parent instanceof OrNode)) {
                            parent = new OrNode(parent);
                            int size = nodes.size();
                            parent.setLocation(size, size + 4);
                            nodes.add(parent);
                            treeCounters.add(3);
                        }
                        this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>((Comparable)Interval.getMinusInf(), false, rightConstant, false)));
                        this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>(rightConstant, false, (Comparable)Interval.getPlusInf(), false)));
                        this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new Predicate<Object>(isRepeated, IsNullCondition.INSTANCE));
                        break;
                    }
                    this.addPredicateNode(parent, nodes, treeCounters, !isNegated, path, new Predicate<Comparable>(isRepeated, new EqualsCondition<Comparable>(rightConstant)));
                    break;
                }
                case EQUAL: {
                    if (this.useIntervals) {
                        this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>(rightConstant, true, rightConstant, true)));
                        break;
                    }
                    this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new Predicate<Comparable>(isRepeated, new EqualsCondition<Comparable>(rightConstant)));
                    break;
                }
                case LESS: {
                    this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>((Comparable)Interval.getMinusInf(), false, rightConstant, false)));
                    break;
                }
                case LESS_OR_EQUAL: {
                    this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>((Comparable)Interval.getMinusInf(), false, rightConstant, true)));
                    break;
                }
                case GREATER: {
                    this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>(rightConstant, false, (Comparable)Interval.getPlusInf(), false)));
                    break;
                }
                case GREATER_OR_EQUAL: {
                    this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new IntervalPredicate<Comparable>(isRepeated, new Interval<Comparable>(rightConstant, true, (Comparable)Interval.getPlusInf(), false)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected comparison type: " + (Object)((Object)expr.getComparisonType()));
                }
            }
        } else if (condition instanceof IsNullExpr) {
            this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new Predicate<Object>(isRepeated, IsNullCondition.INSTANCE));
        } else if (condition instanceof LikeExpr) {
            LikeExpr likeExpr = (LikeExpr)condition;
            this.addPredicateNode(parent, nodes, treeCounters, isNegated, path, new Predicate<String>(isRepeated, new LikeCondition(likeExpr.getPattern(namedParameters), likeExpr.getEscapeChar())));
        } else {
            throw new IllegalStateException("Unexpected condition type (" + condition.getClass().getSimpleName() + "): " + condition);
        }
    }

    private void addPredicateNode(BENode parent, List<BENode> nodes, List<Integer> treeCounters, boolean isNegated, List<AttributeId> path, Predicate predicate) {
        PredicateNode<AttributeId> predicateNode = new PredicateNode<AttributeId>(parent, predicate, isNegated, path);
        int size = nodes.size();
        predicateNode.setLocation(size, size + 1);
        nodes.add(predicateNode);
        treeCounters.add(1);
    }

    private void makeBooleanOperatorNode(BooleanOperatorExpr child, List<BENode> nodes, List<Integer> treeCounters, BENode node, Map<String, Object> namedParameters) {
        int index = nodes.size();
        nodes.add(node);
        List<BooleanExpr> children = child.getChildren();
        treeCounters.add(children.size());
        for (BooleanExpr c : children) {
            this.preorderTraversal(node, c, nodes, treeCounters, namedParameters);
        }
        node.setLocation(index, nodes.size());
    }
}

