/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractNamedFactoryExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class FilterFactoryExtensionProcessor
extends AbstractNamedFactoryExtensionProcessor<CacheEventFilterFactory> {
    public FilterFactoryExtensionProcessor(ServiceName extensionManagerServiceName) {
        super(extensionManagerServiceName);
    }

    @Override
    public Class<CacheEventFilterFactory> getServiceClass() {
        return CacheEventFilterFactory.class;
    }

    @Override
    public AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventFilterFactory> createService(String name, CacheEventFilterFactory instance) {
        return new FilterFactoryService(name, instance);
    }

    private static final class FilterFactoryService
    extends AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventFilterFactory> {
        private FilterFactoryService(String name, CacheEventFilterFactory filterFactory) {
            super(name, filterFactory);
        }

        public void start(StartContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Started key-value filter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).addFilterFactory(this.name, (CacheEventFilterFactory)this.extension);
        }

        @Override
        public String getServiceTypeName() {
            return "key-value-filter-factory";
        }

        public void stop(StopContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Stopped key-value filter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).removeFilterFactory(this.name);
        }

        public CacheEventFilterFactory getValue() {
            return (CacheEventFilterFactory)this.extension;
        }
    }
}

