/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.server.endpoint.subsystem.ModelNodeUtils;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class CacheIgnoreStatusHandler
implements OperationStepHandler {
    public static final CacheIgnoreStatusHandler INSTANCE = new CacheIgnoreStatusHandler();

    private CacheIgnoreStatusHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode ignoreSummary = new ModelNode();
        ModelNode cacheNames = operation.get("cache-names");
        Resource endpointResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        List endpoints = endpointResource.getChildTypes().stream().flatMap(type -> endpointResource.getChildren(type).stream()).collect(Collectors.toList());
        cacheNames.asList().stream().map(ModelNode::asString).forEach(cacheName -> {
            boolean ignoredAllEndpoints = endpoints.stream().map(endpoint -> endpoint.getModel().get("ignored-caches")).allMatch(ignoredList -> ModelNodeUtils.contains(ignoredList, cacheName));
            ignoreSummary.get(cacheName).set(ignoredAllEndpoints);
        });
        context.getResult().set(ignoreSummary);
    }
}

