/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.server.endpoint.subsystem.EncryptableSubsystemHelper;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestAuthMethod;
import org.infinispan.server.endpoint.subsystem.RestAuthenticationResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class RestSubsystemAdd
extends AbstractAddStepHandler {
    static final RestSubsystemAdd INSTANCE = new RestSubsystemAdd();

    RestSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        RestAuthMethod restAuthMethod = RestAuthMethod.NONE;
        ModelNode authConfig = null;
        if (config.hasDefined("authentication") && config.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
            authConfig = config.get(new String[]{"authentication", "AUTHENTICATION"});
            restAuthMethod = RestAuthMethod.valueOf(RestAuthenticationResource.AUTH_METHOD.resolveModelAttribute(context, authConfig).asString());
        }
        String contextPath = RestConnectorResource.CONTEXT_PATH.resolveModelAttribute(context, config).asString();
        ExtendedHeaders extendedHeaders = ExtendedHeaders.valueOf((String)RestConnectorResource.EXTENDED_HEADERS.resolveModelAttribute(context, config).asString());
        Set<String> ignoredCaches = Collections.emptySet();
        if (config.hasDefined("ignored-caches")) {
            ignoredCaches = config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
        }
        int maxContentLength = RestConnectorResource.MAX_CONTENT_LENGTH.resolveModelAttribute(context, config).asInt();
        RestService service = new RestService(this.getServiceName(config), restAuthMethod, RestSubsystemAdd.cleanContextPath(contextPath), extendedHeaders, ignoredCaches, maxContentLength);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "rest"), (Service)service);
        String cacheContainerName = config.hasDefined("cache-container") ? config.get("cache-container").asString() : null;
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        EndpointUtils.addSocketBindingDependency(context, builder, this.getSocketBindingName(operation), service.getSocketBinding());
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector());
        if (authConfig != null && authConfig.hasDefined("security-realm")) {
            EndpointUtils.addSecurityRealmDependency(builder, RestAuthenticationResource.SECURITY_REALM.resolveModelAttribute(context, authConfig).asString(), service.getAuthenticationSecurityRealm());
        }
        EncryptableSubsystemHelper.processEncryption((ExpressionResolver)context, config, service, builder);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    private static String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String getSocketBindingName(ModelNode config) {
        return config.hasDefined("socket-binding") ? config.get("socket-binding").asString() : null;
    }

    protected String getServiceName(ModelNode config) {
        return config.hasDefined("name") ? config.get("name").asString() : "REST";
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        RestSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_LIST_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : RestConnectorResource.REST_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

