/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="DGISPN", length=4)
public interface InfinispanLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = InfinispanLogger.class.getPackage().getName();
    public static final InfinispanLogger ROOT_LOGGER = (InfinispanLogger)Logger.getMessageLogger(InfinispanLogger.class, (String)ROOT_LOGGER_CATEGORY);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=0, value="Activating Infinispan subsystem.")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Started %s cache from %s container")
    public void cacheStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Stopped %s cache from %s container")
    public void cacheStopped(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="The 'eager' attribute specified on the 'transaction' element of a cache is no longer valid")
    public void eagerAttributeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="The '%s' attribute specified on the 'transport' element of a cache container is no longer valid; use the same attribute specified on the 'transport' element of corresponding JGroups stack instead")
    public void topologyAttributeDeprecated(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5, value="'%s' cache container installed.")
    public void cacheContainerInstalled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Attribute 'virtual-nodes' has been deprecated and has no effect.")
    public void virtualNodesAttributeDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Registering Deployed Cache Store service for store '%s'")
    public void installDeployedCacheStore(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8, value="Started Deployed Cache service for implementation '%s'")
    public void deployedStoreStarted(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="Stopped Deployed Cache service for implementation '%s'")
    public void deployedStoreStopped(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="The '%s' attribute has been deprecated and is now ignored. Please use the '%s' configuration element instead")
    public void deprecatedExecutor(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Installing ServerTask service implementation '%s'")
    public void installingDeployedTaskService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=12, value="Registering task '%s'")
    public void registeringDeployedTask(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13, value="Unregistering task '%s'")
    public void unregisteringDeployedTask(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="The 'flush-lock-timeout' attribute specified on the 'write-behind' element of a cache is no longer valid")
    public void flushLockTimeoutDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="The 'shutdown-timeout' attribute specified on the 'write-behind' element of a cache is no longer valid")
    public void shutdownTimeoutDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Waiting for deployment of Custom Cache Store (%s) timed out. Please check if this cache store is really present.")
    public void loadingCustomCacheStoreTimeout(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Found and ignored unsupported (deprecated) attribute 'module' in cache configuration at [row,col] [%s, %s]")
    public void cacheModuleDeprecated(int var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Registering custom EntryMergePolicy '%s'")
    public void registeringCustomMergePolicy(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Unregistering custom EntryMergePolicy '%s'")
    public void unregisteringCustomMergePolicy(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20, value="Waiting for deployment of custom EntryMergePolicy (%s) timed out. Please check if this EntryMergePolicy is really present.")
    public void loadingCustomMergePolicyTimeout(String var1);
}

