/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.BaseEmbeddedQuery;

class HybridQuery
extends BaseEmbeddedQuery {
    protected final ObjectFilter objectFilter;
    protected final Query baseQuery;

    HybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query baseQuery) {
        super(queryFactory, cache, queryString, namedParameters, objectFilter.getProjection(), startOffset, maxResults);
        this.objectFilter = objectFilter;
        this.baseQuery = baseQuery;
    }

    @Override
    protected Comparator<Comparable[]> getComparator() {
        return this.objectFilter.getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getIterator() {
        return new CloseableIterator<ObjectFilter.FilterResult>(){
            private final Iterator<?> it;
            private ObjectFilter.FilterResult nextResult;
            private boolean isReady;
            {
                this.it = HybridQuery.this.getBaseIterator();
                this.nextResult = null;
                this.isReady = false;
            }

            public void close() {
            }

            public boolean hasNext() {
                this.updateNext();
                return this.nextResult != null;
            }

            public ObjectFilter.FilterResult next() {
                this.updateNext();
                if (this.nextResult != null) {
                    ObjectFilter.FilterResult next = this.nextResult;
                    this.isReady = false;
                    this.nextResult = null;
                    return next;
                }
                throw new NoSuchElementException();
            }

            private void updateNext() {
                if (!this.isReady) {
                    while (this.it.hasNext()) {
                        Object next = this.it.next();
                        this.nextResult = HybridQuery.this.objectFilter.filter(next);
                        if (this.nextResult == null) continue;
                        break;
                    }
                    this.isReady = true;
                }
            }
        };
    }

    protected Iterator<?> getBaseIterator() {
        return this.baseQuery.list().iterator();
    }

    @Override
    public String toString() {
        return "HybridQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", baseQuery=" + this.baseQuery + '}';
    }
}

