/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.TopDocs;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class ClusteredTopDocsExternalizer
extends AbstractExternalizer<NodeTopDocs> {
    public Set<Class<? extends NodeTopDocs>> getTypeClasses() {
        return Collections.singleton(NodeTopDocs.class);
    }

    public NodeTopDocs readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int keysNumber = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] keys = new Object[keysNumber];
        for (int i = 0; i < keysNumber; ++i) {
            keys[i] = input.readObject();
        }
        int projectionsNumber = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] projections = new Object[projectionsNumber];
        for (int i = 0; i < projectionsNumber; ++i) {
            projections[i] = input.readObject();
        }
        TopDocs innerTopDocs = (TopDocs)input.readObject();
        return new NodeTopDocs(innerTopDocs, keys, projections);
    }

    public void writeObject(ObjectOutput output, NodeTopDocs topDocs) throws IOException {
        Object[] keys = topDocs.keys;
        int size = keys == null ? 0 : keys.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)size);
        for (int i = 0; i < size; ++i) {
            output.writeObject(keys[i]);
        }
        Object[] projections = topDocs.projections;
        int projectionSize = projections == null ? 0 : projections.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)projectionSize);
        for (int i = 0; i < projectionSize; ++i) {
            output.writeObject(projections[i]);
        }
        output.writeObject(topDocs.topDocs);
    }

    public Integer getId() {
        return ExternalizerIds.CLUSTERED_QUERY_TOPDOCS;
    }
}

