/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.bond.agent;

import io.fabric8.bond.agent.AgentConfiguration;
import io.fabric8.bond.core.AgentDescriptor;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ServiceLoader;

public class AgentBondDispatcher {
    public static void premain(String agentArgs, Instrumentation instrumentation) {
        ServiceLoader<AgentDescriptor> subAgentLoader = ServiceLoader.load(AgentDescriptor.class);
        ArrayList<AgentDescriptor> agents = new ArrayList<AgentDescriptor>();
        HashSet<String> agentIds = new HashSet<String>();
        for (AgentDescriptor agent : subAgentLoader) {
            agents.add(agent);
            agentIds.add(agent.getId());
        }
        AgentConfiguration config = new AgentConfiguration(agentIds, agentArgs);
        for (AgentDescriptor agent : agents) {
            String args = config.getArgs(agent.getId());
            if (args == null) continue;
            AgentBondDispatcher.callPremain(agent.getId(), agent.getPremainClass(), args, instrumentation);
        }
    }

    private static void callPremain(String agentId, Class premainClass, String args, Instrumentation instrumentation) {
        try {
            try {
                Method method = premainClass.getMethod("premain", String.class, Instrumentation.class);
                method.invoke(null, args, instrumentation);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method method = premainClass.getMethod("premain", String.class);
                    method.invoke(null, args != null ? args : "");
                }
                catch (NoSuchMethodException exp) {
                    throw new IllegalArgumentException(agentId + ": Internal, no method premain() found for class " + premainClass);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(agentId + ": Cannot initialize with arguments = " + args + ": " + e, e);
        }
    }

    public static void main(String[] args) {
        System.out.println("Usage: \njava -javaagent:agent-bond.jar=/path/to/configfile\njava -javaagent:agent-bond.jar=<agent-type1>{{ ... opts ...}},<agent-type2>{{ ... opts ...}},...\n");
    }
}

