/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.MBeanServerExecutorLocal;
import org.jolokia.backend.MBeanServerHandlerMBean;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.backend.plugin.MBeanPlugin;
import org.jolokia.backend.plugin.MBeanPluginContext;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.LogHandler;
import org.jolokia.util.ServiceObjectFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerHandler
implements MBeanServerHandlerMBean,
MBeanRegistration {
    private MBeanServerExecutorLocal mBeanServerManager;
    private String qualifier;
    private ServerHandle serverHandle;
    private final List<MBeanHandle> mBeanHandles = new ArrayList<MBeanHandle>();

    public MBeanServerHandler(Configuration pConfig, LogHandler pLogHandler) {
        this.qualifier = pConfig.get(ConfigKey.MBEAN_QUALIFIER);
        List<ServerDetector> detectors = MBeanServerHandler.lookupDetectors();
        this.mBeanServerManager = new MBeanServerExecutorLocal(detectors);
        this.initServerHandle(pConfig, pLogHandler, detectors);
        this.initMBean();
        this.initPlugins(pConfig, pLogHandler);
    }

    private void initPlugins(Configuration pConfig, LogHandler pLogHandler) {
        List<MBeanPlugin> plugins = ServiceObjectFactory.createServiceObjects("META-INF/plugins");
        if (plugins.size() > 0) {
            MBeanPluginContext ctx = this.createMBeanPluginContext();
            Map pluginConfigs = this.getPluginOptions(pConfig, pLogHandler);
            for (MBeanPlugin plugin : plugins) {
                try {
                    plugin.init(ctx, (Map)pluginConfigs.get(plugin.getId()));
                }
                catch (JMException exp) {
                    pLogHandler.error("Error while initializing plugin " + plugin.getId(), exp);
                }
            }
        }
    }

    private Map getPluginOptions(Configuration pConfig, LogHandler pLogHandler) {
        String options = pConfig.get(ConfigKey.MBEAN_PLUGIN_OPTIONS);
        try {
            return options != null ? (JSONObject)new JSONParser().parse(options) : new JSONObject();
        }
        catch (ParseException e) {
            throw new IllegalStateException("Could not parse plugin options '" + options + "' as JSON Objects" + e, e);
        }
    }

    private MBeanPluginContext createMBeanPluginContext() {
        return new MBeanPluginContext(){

            @Override
            public ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException {
                return MBeanServerHandler.this.registerMBean(pMBean, pOptionalName);
            }

            @Override
            public void each(ObjectName pObjectName, MBeanServerExecutor.MBeanEachCallback pCallback) throws IOException, ReflectionException, MBeanException {
                MBeanServerHandler.this.mBeanServerManager.each(pObjectName, pCallback);
            }

            @Override
            public <R> R call(ObjectName pObjectName, MBeanServerExecutor.MBeanAction<R> pMBeanAction, Object ... pExtraArgs) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
                return MBeanServerHandler.this.mBeanServerManager.call(pObjectName, pMBeanAction, pExtraArgs);
            }

            @Override
            public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
                return MBeanServerHandler.this.mBeanServerManager.queryNames(pObjectName);
            }

            @Override
            public boolean hasMBeansListChangedSince(long pTimestamp) {
                return MBeanServerHandler.this.mBeanServerManager.hasMBeansListChangedSince(pTimestamp);
            }
        };
    }

    private void initServerHandle(Configuration pConfig, LogHandler pLogHandler, List<ServerDetector> pDetectors) {
        this.serverHandle = this.detectServers(pDetectors, pLogHandler);
        if (this.serverHandle != null) {
            this.serverHandle.postDetect(this.mBeanServerManager, pConfig, pLogHandler);
        }
    }

    public Object dispatchRequest(JsonRequestHandler pRequestHandler, JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, NotChangedException {
        this.serverHandle.preDispatch(this.mBeanServerManager, pJmxReq);
        if (pRequestHandler.handleAllServersAtOnce(pJmxReq)) {
            try {
                return pRequestHandler.handleRequest(this.mBeanServerManager, pJmxReq);
            }
            catch (IOException e) {
                throw new IllegalStateException("Internal: IOException " + e + ". Shouldn't happen.", e);
            }
        }
        return this.mBeanServerManager.handleRequest(pRequestHandler, pJmxReq);
    }

    public final ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                String name = pOptionalName != null && pOptionalName.length > 0 ? pOptionalName[0] : null;
                ObjectName registeredName = this.serverHandle.registerMBeanAtServer(server, pMBean, name);
                this.mBeanHandles.add(new MBeanHandle(server, registeredName));
                return registeredName;
            }
            catch (RuntimeException exp) {
                throw new IllegalStateException("Could not register " + pMBean + ": " + exp, exp);
            }
            catch (MBeanRegistrationException exp) {
                throw new IllegalStateException("Could not register " + pMBean + ": " + exp, exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws JMException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            ArrayList<JMException> exceptions = new ArrayList<JMException>();
            ArrayList<MBeanHandle> unregistered = new ArrayList<MBeanHandle>();
            for (MBeanHandle handle : this.mBeanHandles) {
                try {
                    unregistered.add(handle);
                    handle.server.unregisterMBean(handle.objectName);
                }
                catch (InstanceNotFoundException e) {
                    exceptions.add(e);
                }
                catch (MBeanRegistrationException e) {
                    exceptions.add(e);
                }
            }
            this.mBeanHandles.removeAll(unregistered);
            if (exceptions.size() == 1) {
                throw (JMException)exceptions.get(0);
            }
            if (exceptions.size() > 1) {
                StringBuilder ret = new StringBuilder();
                for (JMException e : exceptions) {
                    ret.append(e.getMessage()).append(", ");
                }
                throw new JMException(ret.substring(0, ret.length() - 2));
            }
        }
        this.mBeanServerManager.destroy();
    }

    public MBeanServerExecutorLocal getMBeanServerManager() {
        return this.mBeanServerManager;
    }

    public ServerHandle getServerHandle() {
        return this.serverHandle;
    }

    private void initMBean() {
        try {
            this.registerMBean(this, this.getObjectName());
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Internal Error: Own ObjectName " + this.getObjectName() + " is malformed", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalStateException("Internal Error: " + this.getClass().getName() + " is not a compliant MBean", e);
        }
    }

    public static List<ServerDetector> lookupDetectors() {
        List<ServerDetector> detectors = ServiceObjectFactory.createServiceObjects("META-INF/detectors-default", "META-INF/detectors");
        detectors.add(new FallbackServerDetector());
        return detectors;
    }

    private List<MBeanPlugin> lookupMBeanPlugins() {
        return ServiceObjectFactory.createServiceObjects("META-INF/mbean-plugins");
    }

    private ServerHandle detectServers(List<ServerDetector> pDetectors, LogHandler pLogHandler) {
        for (ServerDetector detector : pDetectors) {
            try {
                ServerHandle info = detector.detect(this.mBeanServerManager);
                if (info == null) continue;
                return info;
            }
            catch (Exception exp) {
                pLogHandler.error("Error while using detector " + detector.getClass().getSimpleName() + ": " + exp, exp);
            }
        }
        return null;
    }

    @Override
    public String mBeanServersInfo() {
        return this.mBeanServerManager.getServersInfo();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(this.getObjectName());
    }

    public final String getObjectName() {
        return "jolokia:type=ServerHandler" + (this.qualifier != null ? "," + this.qualifier : "");
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    private static class FallbackServerDetector
    extends AbstractServerDetector {
        private FallbackServerDetector() {
        }

        public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
            return new NullServerHandle();
        }
    }

    private static class NullServerHandle
    extends ServerHandle {
        public NullServerHandle() {
            super(null, null, null, null);
        }
    }

    private static final class MBeanHandle {
        private ObjectName objectName;
        private MBeanServer server;

        private MBeanHandle(MBeanServer pServer, ObjectName pRegisteredName) {
            this.server = pServer;
            this.objectName = pRegisteredName;
        }
    }
}

