/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;

class GetWithMetadataResponse
extends GetResponse {
    protected final long dataVersion;
    protected final long created;
    protected final int lifespan;
    protected final long lastUsed;
    protected final int maxIdle;

    GetWithMetadataResponse(byte version, long messageId, String cacheName, short clientIntel, HotRodOperation operation, OperationStatus status, int topologyId, CacheEntry<byte[], byte[]> ce) {
        super(version, messageId, cacheName, clientIntel, operation, status, topologyId, ce == null ? null : (byte[])ce.getValue());
        this.dataVersion = MetadataUtils.extractVersion(ce);
        this.created = MetadataUtils.extractCreated(ce);
        this.lifespan = MetadataUtils.extractLifespan(ce);
        this.lastUsed = MetadataUtils.extractLastUsed(ce);
        this.maxIdle = MetadataUtils.extractMaxIdle(ce);
    }

    @Override
    public String toString() {
        return "GetWithMetadataResponse{version=" + this.version + ", messageId=" + this.messageId + ", cacheName='" + this.cacheName + '\'' + ", clientIntel=" + this.clientIntel + ", operation=" + (Object)((Object)this.operation) + ", status=" + (Object)((Object)this.status) + ", topologyId=" + this.topologyId + ", data=" + Util.printArray((byte[])this.data, (boolean)true) + ", dataVersion=" + this.dataVersion + ", created=" + this.created + ", lifespan=" + this.lifespan + ", lastUsed=" + this.lastUsed + ", maxIdle=" + this.maxIdle + '}';
    }
}

