/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.iteration;

import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.iteration.CompatInfo;

public class IterableIterationResult {
    private final Set<Integer> finishedSegments;
    private final OperationStatus statusCode;
    private final List<CacheEntry> entries;
    private final CompatInfo compatInfo;
    private final boolean metadata;

    IterableIterationResult(Set<Integer> finishedSegments, OperationStatus statusCode, List<CacheEntry> entries, CompatInfo compatInfo, boolean metadata) {
        this.finishedSegments = finishedSegments;
        this.statusCode = statusCode;
        this.entries = entries;
        this.compatInfo = compatInfo;
        this.metadata = metadata;
    }

    public OperationStatus getStatusCode() {
        return this.statusCode;
    }

    public List<CacheEntry> getEntries() {
        return this.entries;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public boolean isCompatEnabled() {
        return this.compatInfo.enabled;
    }

    public byte[] segmentsToBytes() {
        BitSet bs = new BitSet();
        this.finishedSegments.stream().forEach(bs::set);
        return bs.toByteArray();
    }

    public Object unbox(Object value) {
        if (value == null) {
            return null;
        }
        return this.compatInfo.valueEncoder.fromStorage(value);
    }
}

