/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.multimap;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWriting;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.multimap.MultimapGetWithMetadataResponse;
import org.infinispan.server.hotrod.multimap.MultimapResponse;
import org.infinispan.util.logging.LogFactory;

public final class MultimapCacheDecodeContext {
    static final Log log = (Log)LogFactory.getLog(MultimapCacheDecodeContext.class, Log.class);
    private final EmbeddedMultimapCache<WrappedByteArray, WrappedByteArray> multimapCache;
    private final CacheDecodeContext cacheDecodeContext;
    private final HotRodHeader header;

    public MultimapCacheDecodeContext(AdvancedCache<byte[], byte[]> cache, CacheDecodeContext cacheDecodeContext) {
        this.multimapCache = new EmbeddedMultimapCache(cache);
        this.cacheDecodeContext = cacheDecodeContext;
        this.header = cacheDecodeContext.getHeader();
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        switch (this.header.getOp()) {
            case PUT_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.put());
                break;
            }
            case GET_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.get());
                break;
            }
            case GET_MULTIMAP_WITH_METADATA: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.getWithMetadata());
                break;
            }
            case REMOVE_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.removeKey());
                break;
            }
            case REMOVE_ENTRY_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.removeEntry());
                break;
            }
            case SIZE_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.size());
                break;
            }
            case CONTAINS_ENTRY_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.containsEntry());
                break;
            }
            case CONTAINS_KEY_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.containsKey());
                break;
            }
            case CONTAINS_VALUE_MULTIMAP: {
                ResponseWriting.writeResponse(this.cacheDecodeContext, ctx.channel(), this.containsValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation invoked: " + (Object)((Object)this.header.getOp()));
            }
        }
    }

    public Response get() {
        log.trace("Call get");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        Collection result = (Collection)this.multimapCache.get((Object)keyWrappped).join();
        OperationStatus status = OperationStatus.Success;
        if (result.isEmpty()) {
            status = OperationStatus.KeyDoesNotExist;
        }
        return new MultimapResponse<Set<byte[]>>(this.header, HotRodOperation.GET_MULTIMAP, status, this.mapToCollectionOfByteArrays(result));
    }

    public Response getWithMetadata() {
        log.trace("Call getWithMetadata");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        Optional entry = (Optional)this.multimapCache.getEntry((Object)keyWrappped).join();
        OperationStatus status = OperationStatus.KeyDoesNotExist;
        CacheEntry ce = null;
        Set<byte[]> result = null;
        if (entry.isPresent()) {
            status = OperationStatus.Success;
            ce = (CacheEntry)entry.get();
            result = this.mapToCollectionOfByteArrays((Collection)ce.getValue());
        }
        return new MultimapGetWithMetadataResponse(this.header, status, (CacheEntry<WrappedByteArray, Collection<WrappedByteArray>>)ce, result);
    }

    private Set<byte[]> mapToCollectionOfByteArrays(Collection<WrappedByteArray> result) {
        return result.stream().map(WrappedByteArray::getBytes).collect(Collectors.toSet());
    }

    public Response put() {
        log.trace("Call put");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        WrappedByteArray valueWrapped = new WrappedByteArray(this.cacheDecodeContext.getValue());
        this.multimapCache.put((Object)keyWrappped, (Object)valueWrapped).join();
        return new MultimapResponse<Object>(this.header, HotRodOperation.PUT_MULTIMAP, OperationStatus.Success, null);
    }

    public Response removeKey() {
        log.trace("Call removeKey");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        Boolean result = (Boolean)this.multimapCache.remove((Object)keyWrappped).join();
        return new MultimapResponse<Boolean>(this.header, HotRodOperation.REMOVE_MULTIMAP, OperationStatus.Success, result);
    }

    public Response removeEntry() {
        log.trace("Call removeEntry");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        WrappedByteArray valueWrapped = new WrappedByteArray(this.cacheDecodeContext.getValue());
        Boolean result = (Boolean)this.multimapCache.remove((Object)keyWrappped, (Object)valueWrapped).join();
        return new MultimapResponse<Boolean>(this.header, HotRodOperation.REMOVE_ENTRY_MULTIMAP, OperationStatus.Success, result);
    }

    public Response size() {
        log.trace("Call size");
        Long result = (Long)this.multimapCache.size().join();
        return new MultimapResponse<Long>(this.header, HotRodOperation.SIZE_MULTIMAP, OperationStatus.Success, result);
    }

    public Response containsEntry() {
        log.trace("Call containsEntry");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        WrappedByteArray valueWrapped = new WrappedByteArray(this.cacheDecodeContext.getValue());
        Boolean result = (Boolean)this.multimapCache.containsEntry((Object)keyWrappped, (Object)valueWrapped).join();
        return new MultimapResponse<Boolean>(this.header, HotRodOperation.CONTAINS_ENTRY_MULTIMAP, OperationStatus.Success, result);
    }

    public Response containsKey() {
        log.trace("Call containsKey");
        WrappedByteArray keyWrappped = new WrappedByteArray(this.cacheDecodeContext.getKey());
        Boolean result = (Boolean)this.multimapCache.containsKey((Object)keyWrappped).join();
        return new MultimapResponse<Boolean>(this.header, HotRodOperation.CONTAINS_KEY_MULTIMAP, OperationStatus.Success, result);
    }

    public Response containsValue() {
        log.trace("Call containsValue");
        WrappedByteArray valueWrapped = new WrappedByteArray(this.cacheDecodeContext.getValue());
        Boolean result = (Boolean)this.multimapCache.containsValue((Object)valueWrapped).join();
        return new MultimapResponse<Boolean>(this.header, HotRodOperation.CONTAINS_VALUE_MULTIMAP, OperationStatus.Success, result);
    }
}

