/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model.validator;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public abstract class UniqueTypeValidationStepHandler
implements ModelValidationStepHandler {
    private final ModelElement element;

    public UniqueTypeValidationStepHandler(ModelElement element) {
        this.element = element;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateType(context, operation);
        context.stepCompleted();
    }

    protected void validateType(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String elementName = pathAddress.getLastElement().getValue();
        ModelNode typeNode = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
        String type = this.getType(context, typeNode);
        PathAddress parentAddress = pathAddress.subAddress(0, pathAddress.size() - 1);
        Resource parentResource = context.readResourceFromRoot(parentAddress);
        Set children = parentResource.getChildren(this.element.getName());
        for (Resource.ResourceEntry child : children) {
            String existingResourceName = child.getName();
            String existingType = this.getType(context, child.getModel());
            if (elementName.equals(existingResourceName) || !type.equals(existingType)) continue;
            throw PicketLinkLogger.ROOT_LOGGER.typeAlreadyDefined(type);
        }
    }

    protected abstract String getType(OperationContext var1, ModelNode var2) throws OperationFailedException;
}

