/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.som.idlemit;

import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.PragmaHandler;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.som.cff.Messages;
import java.util.Vector;

public class MetaPragma
extends PragmaHandler {
    public static int metaKey = SymtabEntry.getVariableKey();
    private static int initialState = 0;
    private static int commentState = 1;
    private static int textState = 2;
    private static int finalState = 3;

    @Override
    public boolean process(String pragma, String currentToken) {
        if (!pragma.equals("meta")) {
            return false;
        }
        try {
            SymtabEntry entry = this.scopedName();
            if (entry == null) {
                this.parseException(Messages.msg("idlemit.MetaPragma.scopedNameNotFound"));
                this.skipToEOL();
            } else {
                String msg = this.currentToken() + this.getStringToEOL();
                Vector v = (Vector)entry.dynamicVariable(metaKey);
                if (v == null) {
                    v = new Vector();
                    entry.dynamicVariable(metaKey, v);
                }
                this.parseMsg(v, msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void processForward(ForwardEntry forwardEntry) {
        Vector forwardMeta;
        try {
            forwardMeta = (Vector)forwardEntry.dynamicVariable(metaKey);
        }
        catch (Exception e) {
            forwardMeta = null;
        }
        SymtabEntry forwardInterface = forwardEntry.type();
        if (forwardMeta != null && forwardInterface != null) {
            Vector interfaceMeta;
            try {
                interfaceMeta = (Vector)forwardInterface.dynamicVariable(metaKey);
            }
            catch (Exception e) {
                interfaceMeta = null;
            }
            if (interfaceMeta == null) {
                try {
                    forwardInterface.dynamicVariable(metaKey, forwardMeta);
                }
                catch (Exception e) {}
            } else if (interfaceMeta != forwardMeta) {
                for (int i = 0; i < forwardMeta.size(); ++i) {
                    try {
                        Object obj = forwardMeta.elementAt(i);
                        interfaceMeta.addElement(obj);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void parseMsg(Vector v, String msg) {
        int state = initialState;
        String text = "";
        int index = 0;
        while (state != finalState) {
            boolean isNoMore = index >= msg.length();
            char ch = ' ';
            boolean isSlashStar = false;
            boolean isSlashSlash = false;
            boolean isWhiteSpace = false;
            boolean isStarSlash = false;
            boolean isText = false;
            if (!isNoMore) {
                ch = msg.charAt(index);
                if (ch == '/' && index + 1 < msg.length()) {
                    if (msg.charAt(index + 1) == '/') {
                        isSlashSlash = true;
                        ++index;
                    } else if (msg.charAt(index + 1) == '*') {
                        isSlashStar = true;
                        ++index;
                    } else {
                        isText = true;
                    }
                } else if (ch == '*' && index + 1 < msg.length()) {
                    if (msg.charAt(index + 1) == '/') {
                        isStarSlash = true;
                        ++index;
                    } else {
                        isText = true;
                    }
                } else if (Character.isSpace(ch) || ch == ',' || ch == ';') {
                    isWhiteSpace = true;
                } else {
                    isText = true;
                }
            }
            if (state == initialState) {
                if (isSlashStar) {
                    state = commentState;
                } else if (isSlashSlash || isNoMore) {
                    state = finalState;
                } else if (isText) {
                    state = textState;
                    text = text + ch;
                }
            } else if (state == commentState) {
                if (isNoMore) {
                    state = finalState;
                } else if (isStarSlash) {
                    state = initialState;
                }
            } else if (state == textState) {
                if (isNoMore || isStarSlash || isSlashSlash || isSlashStar || isWhiteSpace) {
                    if (!text.equals("")) {
                        v.addElement(text);
                        text = "";
                    }
                    state = isNoMore ? finalState : (isSlashStar ? commentState : initialState);
                } else if (isText) {
                    text = text + ch;
                }
            }
            ++index;
        }
    }
}

