/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.SecurityActions;
import org.infinispan.globalstate.LocalConfigurationManager;
import org.infinispan.globalstate.impl.EmbeddedLocalConfigurationManager;

public class GlobalStateConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<String> PERSISTENT_LOCATION = AttributeDefinition.builder((String)"persistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> TEMPORARY_LOCATION = AttributeDefinition.builder((String)"temporaryLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("java.io.tmpdir")).immutable().build();
    public static final AttributeDefinition<LocalConfigurationManager> LOCAL_CONFIGURATION_MANAGER = AttributeDefinition.builder((String)"localConfigurationManager", null, LocalConfigurationManager.class).initializer(EmbeddedLocalConfigurationManager::new).immutable().build();
    private final AttributeSet attributes;
    private final Attribute<Boolean> enabled;
    private Attribute<String> persistentLocation;
    private Attribute<String> temporaryLocation;
    private Attribute<LocalConfigurationManager> localConfigurationManager;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{ENABLED, PERSISTENT_LOCATION, TEMPORARY_LOCATION, LOCAL_CONFIGURATION_MANAGER});
    }

    public GlobalStateConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.persistentLocation = attributes.attribute(PERSISTENT_LOCATION);
        this.temporaryLocation = attributes.attribute(TEMPORARY_LOCATION);
        this.localConfigurationManager = attributes.attribute(LOCAL_CONFIGURATION_MANAGER);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public String persistentLocation() {
        return (String)this.persistentLocation.get();
    }

    public String temporaryLocation() {
        return (String)this.temporaryLocation.get();
    }

    public LocalConfigurationManager localConfigurationManager() {
        return (LocalConfigurationManager)this.localConfigurationManager.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + this.attributes + "]";
    }
}

