/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.EntryMergePolicyFactory;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
public class EntryMergePolicyFactoryRegistry {
    private final List<EntryMergePolicyFactory> factories = new ArrayList<EntryMergePolicyFactory>();

    public EntryMergePolicyFactoryRegistry() {
        this.factories.add(new EntryMergePolicyFactory(){

            @Override
            public <T> T createInstance(PartitionHandlingConfiguration config) {
                return (T)config.mergePolicy();
            }
        });
    }

    public EntryMergePolicy createInstance(PartitionHandlingConfiguration config) {
        for (EntryMergePolicyFactory factory : this.factories) {
            Object instance = factory.createInstance(config);
            if (instance == null) continue;
            return (EntryMergePolicy)instance;
        }
        return null;
    }

    public void addMergePolicyFactory(EntryMergePolicyFactory factory) {
        Objects.requireNonNull(factory);
        this.factories.add(0, factory);
    }
}

