/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.EntryMergePolicyFactoryRegistry;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultConflictManager<K, V>
implements InternalConflictManager<K, V> {
    private static Log log = LogFactory.getLog(DefaultConflictManager.class);
    private static boolean trace = log.isTraceEnabled();
    private static final long localFlags = EnumUtil.bitSetOf((Enum)Flag.CACHE_MODE_LOCAL, (Enum)Flag.SKIP_OWNERSHIP_CHECK, (Enum[])new Enum[]{Flag.SKIP_LOCKING});
    private static final Flag[] userMergeFlags = new Flag[]{Flag.IGNORE_RETURN_VALUES};
    private static final Flag[] autoMergeFlags = new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.PUT_FOR_STATE_TRANSFER};
    private AsyncInterceptorChain interceptorChain;
    private AdvancedCache<K, V> cache;
    private CommandsFactory commandsFactory;
    private DistributionManager distributionManager;
    private EntryMergePolicy<K, V> entryMergePolicy;
    private ExecutorService stateTransferExecutor;
    private InvocationContextFactory invocationContextFactory;
    private RpcManager rpcManager;
    private StateConsumer stateConsumer;
    private StateReceiver<K, V> stateReceiver;
    private EntryMergePolicyFactoryRegistry mergePolicyRegistry;
    private String cacheName;
    private Address localAddress;
    private TimeService timeService;
    private long conflictTimeout;
    private final AtomicBoolean streamInProgress = new AtomicBoolean();
    private final Map<K, VersionRequest> versionRequestMap = new HashMap<K, VersionRequest>();
    private final Queue<VersionRequest> retryQueue = new ConcurrentLinkedQueue<VersionRequest>();
    private volatile LocalizedCacheTopology installedTopology;
    private volatile boolean running = false;
    private volatile ReplicaSpliterator conflictSpliterator;

    @Inject
    public void init(AsyncInterceptorChain interceptorChain, AdvancedCache<K, V> cache, CommandsFactory commandsFactory, DistributionManager distributionManager, @ComponentName(value="org.infinispan.executors.stateTransferExecutor") ExecutorService stateTransferExecutor, InvocationContextFactory invocationContextFactory, RpcManager rpcManager, StateConsumer stateConsumer, StateReceiver<K, V> stateReceiver, EntryMergePolicyFactoryRegistry mergePolicyRegistry, TimeService timeService) {
        this.interceptorChain = interceptorChain;
        this.cache = cache;
        this.commandsFactory = commandsFactory;
        this.distributionManager = distributionManager;
        this.stateTransferExecutor = stateTransferExecutor;
        this.invocationContextFactory = invocationContextFactory;
        this.rpcManager = rpcManager;
        this.stateConsumer = stateConsumer;
        this.stateReceiver = stateReceiver;
        this.mergePolicyRegistry = mergePolicyRegistry;
        this.timeService = timeService;
    }

    @Start
    public void start() {
        this.cacheName = this.cache.getName();
        this.localAddress = this.rpcManager.getAddress();
        this.installedTopology = this.distributionManager.getCacheTopology();
        PartitionHandlingConfiguration config = this.cache.getCacheConfiguration().clustering().partitionHandling();
        this.entryMergePolicy = this.mergePolicyRegistry.createInstance(config);
        this.conflictTimeout = this.cache.getCacheConfiguration().clustering().stateTransfer().timeout();
        this.running = true;
        if (trace) {
            log.tracef("Starting %s. isRunning=%s", this.getClass().getSimpleName(), !this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop(priority=0)
    public void stop() {
        if (trace) {
            log.tracef("Stopping %s", this.getClass().getSimpleName());
        }
        this.running = false;
        Map<K, VersionRequest> map = this.versionRequestMap;
        synchronized (map) {
            if (trace) {
                log.tracef("Stopping %s. isRunning=%s. %s", this.getClass().getSimpleName(), this.running, Arrays.toString(Thread.currentThread().getStackTrace()));
            }
            this.cancelVersionRequests();
            this.versionRequestMap.clear();
        }
        if (this.isConflictResolutionInProgress() && this.conflictSpliterator != null) {
            this.conflictSpliterator.stop();
        }
    }

    @Override
    public void onTopologyUpdate(LocalizedCacheTopology cacheTopology) {
        if (!this.running) {
            return;
        }
        this.installedTopology = cacheTopology;
        if (trace) {
            log.tracef("(isRunning=%s) Installed new topology %s: %s", this.running, cacheTopology.getTopologyId(), cacheTopology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVersionRequests() {
        if (!this.running) {
            return;
        }
        Map<K, VersionRequest> map = this.versionRequestMap;
        synchronized (map) {
            this.versionRequestMap.values().forEach(VersionRequest::cancelRequestIfOutdated);
        }
    }

    @Override
    public void restartVersionRequests() {
        VersionRequest request;
        if (!this.running) {
            return;
        }
        while ((request = this.retryQueue.poll()) != null) {
            if (trace) {
                log.tracef("Retrying %s", request);
            }
            request.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Address, InternalCacheValue<V>> getAllVersions(K key) {
        VersionRequest request;
        this.checkIsRunning();
        Map<Object, Object> map = this.versionRequestMap;
        synchronized (map) {
            request = this.versionRequestMap.computeIfAbsent(key, k -> new VersionRequest(k, this.stateConsumer.isStateTransferInProgress()));
        }
        try {
            map = request.completableFuture.get();
            return map;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CacheException) {
                throw (CacheException)e.getCause();
            }
            throw new CacheException(e.getCause());
        }
        finally {
            Map<K, VersionRequest> map2 = this.versionRequestMap;
            synchronized (map2) {
                this.versionRequestMap.remove(key);
            }
        }
    }

    @Override
    public Stream<Map<Address, CacheEntry<K, V>>> getConflicts() {
        this.checkIsRunning();
        return this.getConflicts(this.installedTopology);
    }

    private Stream<Map<Address, CacheEntry<K, V>>> getConflicts(LocalizedCacheTopology topology) {
        if (topology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION && this.stateConsumer.isStateTransferInProgress()) {
            throw log.getConflictsStateTransferInProgress(this.cacheName);
        }
        if (!this.streamInProgress.compareAndSet(false, true)) {
            throw log.getConflictsAlreadyInProgress();
        }
        this.conflictSpliterator = new ReplicaSpliterator(topology);
        if (!this.running) {
            this.conflictSpliterator.stop();
            return Stream.empty();
        }
        return StreamSupport.stream(new ReplicaSpliterator(topology), false).filter(this.filterConsistentEntries());
    }

    @Override
    public boolean isConflictResolutionInProgress() {
        return this.streamInProgress.get();
    }

    @Override
    public void resolveConflicts() {
        if (this.entryMergePolicy == null) {
            throw new CacheException("Cannot resolve conflicts as no EntryMergePolicy has been configured");
        }
        this.resolveConflicts(this.entryMergePolicy);
    }

    @Override
    public void resolveConflicts(EntryMergePolicy<K, V> mergePolicy) {
        this.checkIsRunning();
        this.doResolveConflicts(this.installedTopology, mergePolicy, true);
    }

    @Override
    public void resolveConflicts(CacheTopology topology) {
        if (!this.running) {
            return;
        }
        LocalizedCacheTopology localizedTopology = topology instanceof LocalizedCacheTopology ? (LocalizedCacheTopology)topology : this.distributionManager.createLocalizedCacheTopology(topology);
        this.doResolveConflicts(localizedTopology, this.entryMergePolicy, false);
    }

    private void doResolveConflicts(LocalizedCacheTopology topology, EntryMergePolicy<K, V> mergePolicy, boolean userCall) {
        HashSet<Address> preferredPartition = new HashSet<Address>(topology.getCurrentCH().getMembers());
        AdvancedCache<K, V> cache = this.cache.withFlags(userCall ? userMergeFlags : autoMergeFlags);
        if (trace) {
            log.tracef("Cache %s Attempting to resolve conflicts.  All Members %s, Installed topology %s, Preferred Partition %s", new Object[]{this.cacheName, topology.getMembers(), topology, preferredPartition});
        }
        Phaser phaser = new Phaser(1);
        this.getConflicts(topology).forEach(conflictMap -> {
            phaser.register();
            this.stateTransferExecutor.execute(() -> {
                CompletableFuture future;
                List otherEntries;
                CacheEntry entry2;
                CacheEntry mergedEntry;
                if (trace) {
                    log.tracef("Cache %s Conflict detected %s", this.cacheName, conflictMap);
                }
                Collection entries = conflictMap.values();
                Optional<Object> optionalEntry = entries.stream().filter(entry -> !(entry instanceof NullCacheEntry)).map(CacheEntry::getKey).findAny();
                Object key = optionalEntry.orElseThrow(() -> new CacheException("All returned conflicts are NullCacheEntries. This should not happen!"));
                Address primaryReplica = topology.getDistribution(key).primary();
                List preferredEntries = conflictMap.entrySet().stream().map(Map.Entry::getKey).filter(preferredPartition::contains).collect(Collectors.toList());
                CacheEntry preferredEntry = preferredEntries.size() == 1 ? (CacheEntry)conflictMap.remove(preferredEntries.get(0)) : (CacheEntry)conflictMap.remove(primaryReplica);
                if (trace) {
                    log.tracef("Cache %s Applying EntryMergePolicy %s to PreferredEntry %s, otherEntries %s", new Object[]{this.cacheName, mergePolicy.getClass().getName(), preferredEntry, entries});
                }
                if ((mergedEntry = mergePolicy.merge(entry2 = preferredEntry instanceof NullCacheEntry ? null : preferredEntry, otherEntries = entries.stream().filter(e -> !(e instanceof NullCacheEntry)).collect(Collectors.toList()))) == null) {
                    if (trace) {
                        log.tracef("Cache %s Executing remove on conflict: key %s", this.cacheName, key);
                    }
                    future = cache.removeAsync(key);
                } else {
                    if (trace) {
                        log.tracef("Cache %s Executing update on conflict: key %s with value %s", this.cacheName, key, mergedEntry.getValue());
                    }
                    future = cache.putAsync(key, mergedEntry.getValue(), mergedEntry.getMetadata());
                }
                future.whenComplete((responseMap, exception) -> {
                    if (trace) {
                        log.tracef("Cache %s ResolveConflicts future complete for key %s: ResponseMap=%s, Exception=%s", new Object[]{this.cacheName, key, responseMap, exception});
                    }
                    phaser.arriveAndDeregister();
                    if (exception != null) {
                        log.exceptionDuringConflictResolution(key, (Throwable)exception);
                    }
                });
            });
        });
        phaser.arriveAndAwaitAdvance();
        if (trace) {
            log.tracef("Cache %s Finished resolving conflicts for topologyId=%s", this.cacheName, topology.getTopologyId());
        }
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.stateConsumer.isStateTransferInProgress();
    }

    private void checkIsRunning() {
        if (!this.running) {
            throw new CacheException(String.format("Cache %s Unable to process request as the ConflictManager has been stopped", this.cacheName));
        }
    }

    private Predicate<? super Map<Address, CacheEntry<K, V>>> filterConsistentEntries() {
        return map -> map.values().stream().distinct().limit(2L).count() > 1L || map.values().isEmpty();
    }

    private class ReplicaSpliterator
    extends Spliterators.AbstractSpliterator<Map<Address, CacheEntry<K, V>>> {
        private final LocalizedCacheTopology topology;
        private final int totalSegments;
        private final long endTime;
        private int nextSegment;
        private Iterator<Map<Address, CacheEntry<K, V>>> iterator;
        private volatile CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> segmentRequestFuture;

        ReplicaSpliterator(LocalizedCacheTopology topology) {
            super(Long.MAX_VALUE, 257);
            this.nextSegment = 0;
            this.iterator = Collections.emptyIterator();
            this.topology = topology;
            this.totalSegments = topology.getWriteConsistentHash().getNumSegments();
            this.endTime = DefaultConflictManager.this.timeService.expectedEndTime(DefaultConflictManager.this.conflictTimeout, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map<Address, CacheEntry<K, V>>> action) {
            while (!this.iterator.hasNext()) {
                if (this.nextSegment < this.totalSegments) {
                    try {
                        if (trace) {
                            log.tracef("Attempting to receive all replicas for segment %s with topology %s", this.nextSegment, this.topology);
                        }
                        this.segmentRequestFuture = DefaultConflictManager.this.stateReceiver.getAllReplicasForSegment(this.nextSegment, this.topology);
                        long remainingTime = DefaultConflictManager.this.timeService.remainingTime(this.endTime, TimeUnit.MILLISECONDS);
                        List segmentEntries = this.segmentRequestFuture.get(remainingTime, TimeUnit.MILLISECONDS);
                        if (trace && !segmentEntries.isEmpty()) {
                            log.tracef("Segment %s entries received: %s", this.nextSegment, segmentEntries);
                        }
                        ++this.nextSegment;
                        this.iterator = segmentEntries.iterator();
                        continue;
                    }
                    catch (CancellationException e) {
                        if (trace) {
                            log.tracef("ReplicaSpliterator caught %s", e);
                        }
                        DefaultConflictManager.this.streamInProgress.set(false);
                        return false;
                    }
                    catch (InterruptedException e) {
                        if (trace) {
                            log.tracef("ReplicaSpliterator caught %s", e);
                        }
                        DefaultConflictManager.this.stateReceiver.stop();
                        DefaultConflictManager.this.streamInProgress.set(false);
                        Thread.currentThread().interrupt();
                        throw new CacheException((Throwable)e);
                    }
                    catch (ExecutionException | TimeoutException e) {
                        if (trace) {
                            log.tracef("ReplicaSpliterator caught %s", e);
                        }
                        DefaultConflictManager.this.streamInProgress.set(false);
                        throw new CacheException(e.getMessage(), e.getCause());
                    }
                }
                DefaultConflictManager.this.streamInProgress.compareAndSet(true, false);
                return false;
            }
            action.accept(this.iterator.next());
            return true;
        }

        void stop() {
            if (trace) {
                log.tracef("Stop called on ReplicaSpliterator. Current segment %s", this.nextSegment);
            }
            if (this.segmentRequestFuture != null) {
                this.segmentRequestFuture.cancel(true);
            }
        }
    }

    private class VersionRequest {
        final K key;
        final boolean postpone;
        final CompletableFuture<Map<Address, InternalCacheValue<V>>> completableFuture = new CompletableFuture();
        volatile CompletableFuture<Map<Address, Response>> rpcFuture;
        volatile Collection<Address> keyOwners;

        VersionRequest(K key, boolean postpone) {
            this.key = key;
            this.postpone = postpone;
            if (trace) {
                log.tracef("Cache %s Creating %s", DefaultConflictManager.this.cacheName, this);
            }
            if (postpone) {
                DefaultConflictManager.this.retryQueue.add(this);
            } else {
                this.start();
            }
        }

        void cancelRequestIfOutdated() {
            Collection<Address> latestOwners = DefaultConflictManager.this.installedTopology.getWriteOwners(this.key);
            if (this.rpcFuture != null && !this.completableFuture.isDone() && !this.keyOwners.equals(latestOwners)) {
                this.rpcFuture = null;
                this.keyOwners.clear();
                if (this.rpcFuture.cancel(false)) {
                    DefaultConflictManager.this.retryQueue.add(this);
                    if (trace) {
                        log.tracef("Cancelling %s for nodes %s. New write owners %s", this, this.keyOwners, latestOwners);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            TopologyAffectedCommand cmd;
            LocalizedCacheTopology topology = DefaultConflictManager.this.installedTopology;
            this.keyOwners = topology.getWriteOwners(this.key);
            if (trace) {
                log.tracef("Attempting %s from owners %s", this, this.keyOwners);
            }
            HashMap versionsMap = new HashMap();
            if (this.keyOwners.contains(DefaultConflictManager.this.localAddress)) {
                cmd = DefaultConflictManager.this.commandsFactory.buildGetCacheEntryCommand(this.key, localFlags);
                NonTxInvocationContext ctx = DefaultConflictManager.this.invocationContextFactory.createNonTxInvocationContext();
                InternalCacheEntry internalCacheEntry = (InternalCacheEntry)DefaultConflictManager.this.interceptorChain.invoke(ctx, (VisitableCommand)((Object)cmd));
                InternalCacheValue icv = internalCacheEntry == null ? null : internalCacheEntry.toInternalCacheValue();
                HashMap hashMap = versionsMap;
                synchronized (hashMap) {
                    versionsMap.put(DefaultConflictManager.this.localAddress, icv);
                }
            }
            cmd = DefaultConflictManager.this.commandsFactory.buildClusteredGetCommand(this.key, FlagBitSets.SKIP_OWNERSHIP_CHECK);
            ((BaseClusteredReadCommand)cmd).setTopologyId(topology.getTopologyId());
            MapResponseCollector collector = MapResponseCollector.ignoreLeavers(this.keyOwners.size());
            this.rpcFuture = DefaultConflictManager.this.rpcManager.invokeCommand(this.keyOwners, (ReplicableCommand)cmd, collector, DefaultConflictManager.this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
            this.rpcFuture.whenComplete((responseMap, exception) -> {
                if (trace) {
                    log.tracef("%s received responseMap %s, exception %s", this, responseMap, exception);
                }
                if (exception != null) {
                    String msg = String.format("%s encountered when attempting '%s' on cache '%s'", exception.getCause(), this, DefaultConflictManager.this.cacheName);
                    this.completableFuture.completeExceptionally((Throwable)new CacheException(msg, exception.getCause()));
                    return;
                }
                for (Map.Entry entry : responseMap.entrySet()) {
                    Response rsp;
                    if (trace) {
                        log.tracef("%s received response %s from %s", this, entry.getValue(), entry.getKey());
                    }
                    if ((rsp = (Response)entry.getValue()) instanceof SuccessfulResponse) {
                        SuccessfulResponse response = (SuccessfulResponse)rsp;
                        Object rspVal = response.getResponseValue();
                        Map map = versionsMap;
                        synchronized (map) {
                            versionsMap.put((Address)entry.getKey(), (InternalCacheValue)rspVal);
                            continue;
                        }
                    }
                    if (rsp instanceof UnsureResponse) {
                        log.debugf("Received UnsureResponse, restarting request %s", this);
                        this.start();
                        return;
                    }
                    if (rsp instanceof CacheNotFoundResponse) {
                        if (!trace) continue;
                        log.tracef("Ignoring CacheNotFoundResponse: %s", rsp);
                        continue;
                    }
                    this.completableFuture.completeExceptionally((Throwable)new CacheException(String.format("Unable to retrieve key %s from %s: %s", this.key, entry.getKey(), entry.getValue())));
                    return;
                }
                this.completableFuture.complete(versionsMap);
            });
        }

        public String toString() {
            return "VersionRequest{key=" + this.key + ", postpone=" + this.postpone + '}';
        }
    }
}

