/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.InboundTransferTask;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.topology.CacheTopology;

@Listener
public class StateReceiverImpl<K, V>
implements StateReceiver<K, V> {
    private static final Log log = LogFactory.getLog(StateReceiverImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private String cacheName;
    private Cache<K, V> cache;
    private CommandsFactory commandsFactory;
    private DataContainer<K, V> dataContainer;
    private RpcManager rpcManager;
    private long transferTimeout;
    private final ConcurrentHashMap<Integer, SegmentRequest> requestMap = new ConcurrentHashMap();

    @Inject
    public void init(Cache<K, V> cache, CommandsFactory commandsFactory, DataContainer<K, V> dataContainer, RpcManager rpcManager) {
        this.cache = cache;
        this.commandsFactory = commandsFactory;
        this.dataContainer = dataContainer;
        this.rpcManager = rpcManager;
    }

    @Start
    public void start() {
        this.cache.addListener(this);
        this.cacheName = this.cache.getName();
        this.transferTimeout = this.cache.getCacheConfiguration().clustering().stateTransfer().timeout();
    }

    @Override
    @Stop
    public void stop() {
        if (trace) {
            log.tracef("Stop called on StateReceiverImpl for cache %s", (Object)this.cacheName);
        }
        for (SegmentRequest request : this.requestMap.values()) {
            request.cancel(null);
        }
    }

    @DataRehashed
    public void onDataRehash(DataRehashedEvent dataRehashedEvent) {
        if (dataRehashedEvent.isPre()) {
            for (SegmentRequest request : this.requestMap.values()) {
                request.cancel((Throwable)new CacheException("Cancelling replica request as the owners of the requested segment have changed."));
            }
        }
    }

    @Override
    public CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> getAllReplicasForSegment(int segmentId, LocalizedCacheTopology topology) {
        return this.requestMap.computeIfAbsent(segmentId, id -> new SegmentRequest((int)id, topology)).requestState();
    }

    @Override
    public void receiveState(Address sender, int topologyId, Collection<StateChunk> stateChunks) {
        if (stateChunks.isEmpty()) {
            if (trace) {
                log.tracef("Cache %s Ignoring received state from %s because stateChunks are empty", (Object)this.cacheName, (Object)sender);
            }
            return;
        }
        int segmentId = stateChunks.iterator().next().getSegmentId();
        SegmentRequest request = this.requestMap.get(segmentId);
        if (request == null) {
            if (trace) {
                log.tracef("Cache %s Ignoring received state because the associated request was completed or cancelled %s", (Object)this.cacheName);
            }
            return;
        }
        request.receiveState(sender, topologyId, stateChunks);
    }

    Map<K, Map<Address, CacheEntry<K, V>>> getKeyReplicaMap(int segmentId) {
        return this.requestMap.get((Object)Integer.valueOf((int)segmentId)).keyReplicaMap;
    }

    Map<Address, InboundTransferTask> getTransferTaskMap(int segmentId) {
        return this.requestMap.get((Object)Integer.valueOf((int)segmentId)).transferTaskMap;
    }

    InboundTransferTask createTransferTask(int segmentId, Address source, CacheTopology topology) {
        return new InboundTransferTask(Collections.singleton(segmentId), source, topology.getTopologyId(), this.rpcManager, this.commandsFactory, this.transferTimeout, this.cacheName, false);
    }

    class SegmentRequest {
        final int segmentId;
        final LocalizedCacheTopology topology;
        final List<Address> replicaHosts;
        final Map<K, Map<Address, CacheEntry<K, V>>> keyReplicaMap = new HashMap();
        final Map<Address, InboundTransferTask> transferTaskMap = new HashMap<Address, InboundTransferTask>();
        CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> future;

        SegmentRequest(int segmentId, LocalizedCacheTopology topology) {
            this.segmentId = segmentId;
            this.topology = topology;
            this.replicaHosts = topology.getDistributionForSegment(segmentId).writeOwners();
        }

        synchronized CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> requestState() {
            assert (this.future == null);
            if (trace) {
                log.tracef("Cache %s Attempting to receive replicas for segment %s from %s with topology %s", new Object[]{StateReceiverImpl.this.cacheName, this.segmentId, this.replicaHosts, this.topology});
            }
            ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
            for (Address replica : this.replicaHosts) {
                if (replica.equals(StateReceiverImpl.this.rpcManager.getAddress())) {
                    StateReceiverImpl.this.dataContainer.forEach(entry -> {
                        int keySegment = this.topology.getDistribution(entry.getKey()).segmentId();
                        if (keySegment == this.segmentId) {
                            this.addKeyToReplicaMap(replica, (CacheEntry)entry);
                        }
                    });
                    continue;
                }
                InboundTransferTask transferTask = StateReceiverImpl.this.createTransferTask(this.segmentId, replica, this.topology);
                this.transferTaskMap.put(replica, transferTask);
                completableFutures.add(transferTask.requestSegments());
            }
            CompletableFuture<Void> allSegmentRequests = CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[completableFutures.size()]));
            allSegmentRequests.exceptionally(throwable -> {
                if (trace) {
                    log.tracef(throwable, "Exception when processing InboundTransferTask for cache %s", (Object)StateReceiverImpl.this.cacheName);
                }
                this.cancel((Throwable)throwable);
                return null;
            });
            this.future = allSegmentRequests.thenApply(aVoid -> {
                List retVal = this.keyReplicaMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
                this.clear();
                return Collections.unmodifiableList(retVal);
            });
            return this.future;
        }

        synchronized void clear() {
            this.keyReplicaMap.clear();
            this.transferTaskMap.clear();
            StateReceiverImpl.this.requestMap.remove(this.segmentId);
        }

        synchronized void receiveState(Address sender, int topologyId, Collection<StateChunk> stateChunks) {
            if (topologyId < this.topology.getTopologyId()) {
                if (trace) {
                    log.tracef("Discarding state response with old topology id %d for cache %s, the smallest allowed topology id is %d", topologyId, this.topology.getTopologyId(), (Object)StateReceiverImpl.this.cacheName);
                }
                return;
            }
            InboundTransferTask transferTask = this.transferTaskMap.get(sender);
            if (transferTask == null) {
                if (trace) {
                    log.tracef("State received for an unknown request. No record of a state request exists for node %s", (Object)sender);
                }
                return;
            }
            if (trace) {
                log.tracef("State chunks received from %s, with topologyId %s, statechunks %s", (Object)sender, (Object)topologyId, stateChunks);
            }
            for (StateChunk chunk : stateChunks) {
                boolean isLastChunk = chunk.isLastChunk();
                chunk.getCacheEntries().forEach(ice -> this.addKeyToReplicaMap(sender, (CacheEntry)ice));
                transferTask.onStateReceived(chunk.getSegmentId(), isLastChunk);
                if (!isLastChunk) continue;
                this.transferTaskMap.remove(sender);
            }
        }

        synchronized void cancel(Throwable throwable) {
            log.debugf(throwable, "Cancelling request for segment %s on cache %s", this.segmentId, (Object)StateReceiverImpl.this.cacheName);
            this.transferTaskMap.forEach((address, inboundTransferTask) -> inboundTransferTask.cancel());
            if (throwable != null) {
                this.future.completeExceptionally(throwable);
            } else {
                this.future.cancel(true);
            }
            this.clear();
        }

        void addKeyToReplicaMap(Address address, CacheEntry<K, V> ice) {
            this.keyReplicaMap.computeIfAbsent(ice.getKey(), k -> {
                HashMap map = new HashMap();
                this.replicaHosts.forEach(a -> {
                    CacheEntry cfr_ignored_0 = map.put(a, NullCacheEntry.getInstance());
                });
                return map;
            }).put(address, ice);
        }

        public String toString() {
            return "SegmentRequest{segmentId=" + this.segmentId + ", topology=" + this.topology.getTopologyId() + ", replicaHosts=" + this.replicaHosts + ", keyReplicaMap=" + this.keyReplicaMap + ", transferTaskMap=" + this.transferTaskMap + ", future=" + this.future + '}';
        }
    }
}

