/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ClusterExpirationManager<K, V>
extends ExpirationManagerImpl<K, V> {
    private static final Log log = LogFactory.getLog(ClusterExpirationManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private ExecutorService asyncExecutor;
    private AdvancedCache<K, V> cache;
    private boolean needTransaction;

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Inject
    public void inject(AdvancedCache<K, V> cache, Configuration configuration, @ComponentName(value="org.infinispan.executors.async") ExecutorService asyncExecutor) {
        this.cache = cache;
        this.asyncExecutor = asyncExecutor;
        this.needTransaction = configuration.transaction().transactionMode().isTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                long currentTimeMillis = this.timeService.wallClockTime();
                Iterator purgeCandidates = this.dataContainer.iteratorIncludingExpired();
                while (purgeCandidates.hasNext()) {
                    boolean expiredTransient;
                    boolean expiredMortal;
                    long lifespan;
                    Object value;
                    InternalCacheEntry e = purgeCandidates.next();
                    if (!e.canExpire()) continue;
                    InternalCacheEntry internalCacheEntry = e;
                    synchronized (internalCacheEntry) {
                        value = e.getValue();
                        lifespan = e.getLifespan();
                        expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, e.getCreated(), currentTimeMillis);
                        expiredTransient = ExpiryHelper.isExpiredTransient(e.getMaxIdle(), e.getLastUsed(), currentTimeMillis);
                    }
                    if (expiredMortal) {
                        this.handleLifespanExpireEntry(e.getKey(), value, lifespan, true);
                        continue;
                    }
                    if (!expiredTransient) continue;
                    super.handleInMemoryExpiration(e, currentTimeMillis);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    void handleLifespanExpireEntry(K key, V value, long lifespan, boolean sync) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had lifespan of %s", Util.toStr(key), lifespan);
            }
            Runnable runnable = () -> {
                try {
                    this.removeExpired(key, value, lifespan);
                }
                finally {
                    this.expiring.remove(key);
                }
            };
            if (sync) {
                runnable.run();
            } else {
                this.asyncExecutor.submit(runnable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeExpired(K key, V value, Long lifespan) {
        if (this.needTransaction) {
            TransactionManager tm = this.cache.getTransactionManager();
            try {
                Transaction tx = tm.suspend();
                try {
                    tm.begin();
                    this.cache.removeExpired(key, value, lifespan);
                }
                catch (NotSupportedException | SystemException e) {
                    tm.rollback();
                    throw e;
                }
                finally {
                    tm.commit();
                }
                if (tx == null) return;
                tm.resume(tx);
                return;
            }
            catch (HeuristicMixedException | HeuristicRollbackException | InvalidTransactionException | NotSupportedException | RollbackException | SystemException e) {
                throw new CacheException(e);
            }
        }
        this.cache.removeExpired(key, value, lifespan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInMemoryExpiration(InternalCacheEntry<K, V> entry, long currentTime) {
        boolean expiredMortal;
        long lifespan;
        Object value;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            value = entry.getValue();
            lifespan = entry.getLifespan();
            expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, entry.getCreated(), currentTime);
        }
        if (expiredMortal) {
            this.handleLifespanExpireEntry(entry.getKey(), value, lifespan, false);
        } else {
            super.handleInMemoryExpiration(entry, currentTime);
        }
    }

    @Override
    public void handleInStoreExpiration(K key) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                this.removeExpired(key, null, null);
            }
            finally {
                this.expiring.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        K key = marshalledEntry.getKey();
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                InternalMetadata metadata = marshalledEntry.getMetadata();
                this.removeExpired(key, marshalledEntry.getValue(), metadata.lifespan() == -1L ? null : Long.valueOf(metadata.lifespan()));
            }
            finally {
                this.expiring.remove(key);
            }
        }
    }
}

