/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.LocalConfigurationManager;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EmbeddedLocalConfigurationManager
implements LocalConfigurationManager {
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private ConcurrentHashSet<String> persistentCaches = new ConcurrentHashSet();
    private EmbeddedCacheManager cacheManager;
    private ParserRegistry parserRegistry;
    private GlobalConfiguration globalConfiguration;

    @Override
    public void initialize(EmbeddedCacheManager cacheManager, GlobalConfigurationManager globalConfigurationManager) {
        this.globalConfiguration = cacheManager.getCacheManagerConfiguration();
        this.cacheManager = cacheManager;
        this.parserRegistry = new ParserRegistry();
    }

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT) && !this.globalConfiguration.globalState().enabled()) {
            throw log.globalStateDisabled();
        }
    }

    @Override
    public void createCache(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = this.cacheManager.getCacheConfiguration(name);
        if (existing == null) {
            this.cacheManager.defineConfiguration(name, configuration);
            log.debugf("Defined cache '%s' on '%s' using %s", name, this.cacheManager.getAddress(), configuration);
        } else {
            if (!existing.matches(configuration)) {
                throw log.incompatibleClusterConfiguration(name, configuration, existing);
            }
            log.debugf("%s already has a cache %s with configuration %s", this.cacheManager.getAddress(), name, configuration);
        }
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT)) {
            this.persistentCaches.add((Object)name);
            this.storeAll();
        }
        this.cacheManager.getCache(name);
    }

    @Override
    public void removeCache(String name) {
        GlobalComponentRegistry globalComponentRegistry;
        ComponentRegistry cacheComponentRegistry;
        log.debugf("Remove cache %s", name);
        if (this.persistentCaches.remove((Object)name)) {
            this.storeAll();
        }
        if ((cacheComponentRegistry = (globalComponentRegistry = this.cacheManager.getGlobalComponentRegistry()).getNamedComponentRegistry(name)) != null) {
            cacheComponentRegistry.getComponent(PersistenceManager.class).setClearOnStop(true);
            cacheComponentRegistry.getComponent(CacheJmxRegistration.class).setUnregisterCacheMBean(true);
            cacheComponentRegistry.getComponent(PassivationManager.class).skipPassivationOnStop(true);
            Cache cache = this.cacheManager.getCache(name, false);
            if (cache != null) {
                cache.stop();
            }
        }
        globalComponentRegistry.removeCache(name);
        globalComponentRegistry.getComponent(ConfigurationManager.class).removeConfiguration(name);
        globalComponentRegistry.getComponent(DependencyGraph.class, "org.infinispan.CacheDependencyGraph").remove(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Configuration> loadAll() {
        try (FileInputStream fis = new FileInputStream(this.getPersistentFile());){
            HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
            ConfigurationBuilderHolder holder = this.parserRegistry.parse(fis);
            for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                String name = entry.getKey();
                Configuration configuration = entry.getValue().build();
                configurations.put(name, configuration);
            }
            HashMap<String, Configuration> hashMap = configurations;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            return Collections.emptyMap();
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAll() {
        try {
            Object cacheName2;
            File temp = File.createTempFile("caches", null, new File(this.globalConfiguration.globalState().persistentLocation()));
            HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
            for (Object cacheName2 : this.persistentCaches) {
                configurationMap.put((String)cacheName2, this.cacheManager.getCacheConfiguration((String)cacheName2));
            }
            FileOutputStream f = new FileOutputStream(temp);
            cacheName2 = null;
            try {
                this.parserRegistry.serialize((OutputStream)f, null, configurationMap);
            }
            catch (Throwable throwable) {
                cacheName2 = throwable;
                throw throwable;
            }
            finally {
                if (f != null) {
                    if (cacheName2 != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)cacheName2).addSuppressed(throwable);
                        }
                    } else {
                        f.close();
                    }
                }
            }
            FileLock lock = null;
            try (FileOutputStream lockFile = new FileOutputStream(this.getPersistentFileLock());){
                lock = lockFile.getChannel().lock();
                if (!temp.renameTo(this.getPersistentFile())) {
                    throw log.cannotRenamePersistentFile(temp.getAbsolutePath(), this.getPersistentFile());
                }
            }
            finally {
                if (lock != null && lock.isValid()) {
                    lock.release();
                }
                this.getPersistentFileLock().delete();
            }
        }
        catch (Exception e) {
            throw log.errorPersistingGlobalConfiguration(e);
        }
    }

    private File getPersistentFile() {
        return new File(this.globalConfiguration.globalState().persistentLocation(), "caches.xml");
    }

    private File getPersistentFileLock() {
        return new File(this.globalConfiguration.globalState().persistentLocation(), "caches.xml.lck");
    }
}

