/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.PostStart;
import org.infinispan.factories.annotations.Start;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.LocalConfigurationManager;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationStateListener;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalConfigurationManagerImpl
implements GlobalConfigurationManager {
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String CACHE_SCOPE = "cache";
    private EmbeddedCacheManager cacheManager;
    private Cache<ScopedState, Object> stateCache;
    private ParserRegistry parserRegistry;
    private LocalConfigurationManager localConfigurationManager;

    @Inject
    public void inject(GlobalConfiguration globalConfiguration, EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.localConfigurationManager = globalConfiguration.globalState().localConfigurationManager();
    }

    @Start
    public void start() {
        InternalCacheRegistry internalCacheRegistry = this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("org.infinispan.CONFIG", new ConfigurationBuilder().build(), EnumSet.of(InternalCacheRegistry.Flag.GLOBAL));
        this.parserRegistry = new ParserRegistry();
        this.cacheManager.getGlobalComponentRegistry().wireDependencies(this.localConfigurationManager);
    }

    @PostStart
    public void postStart() {
        this.localConfigurationManager.initialize(this.cacheManager, this);
        CloseableIterator closeableIterator = this.getStateCache().entrySet().iterator();
        while (closeableIterator.hasNext()) {
            Map.Entry e = (Map.Entry)closeableIterator.next();
            if (!CACHE_SCOPE.equals(((ScopedState)e.getKey()).getScope())) continue;
            this.createCacheLocally(((ScopedState)e.getKey()).getName(), (CacheState)e.getValue());
        }
        GlobalConfigurationStateListener stateCacheListener = new GlobalConfigurationStateListener(this);
        this.getStateCache().addListener(stateCacheListener, new ScopeFilter(CACHE_SCOPE));
        this.localConfigurationManager.loadAll().forEach((name, configuration) -> this.getOrCreateCache((String)name, (Configuration)configuration, EnumSet.of(CacheContainerAdmin.AdminFlag.PERMANENT)));
    }

    public Cache<ScopedState, Object> getStateCache() {
        if (this.stateCache == null) {
            this.stateCache = this.cacheManager.getCache("org.infinispan.CONFIG");
        }
        return this.stateCache;
    }

    @Override
    public Configuration createCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw log.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, configuration, flags);
    }

    @Override
    public Configuration getOrCreateCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.createCache(cacheName, null, configuration, flags);
    }

    @Override
    public Configuration createCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw log.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, template, flags);
    }

    @Override
    public Configuration getOrCreateCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration configuration;
        if (template == null) {
            if (this.cacheManager.cacheExists(cacheName)) {
                return this.cacheManager.getCacheConfiguration(cacheName);
            }
            configuration = this.cacheManager.getDefaultCacheConfiguration();
            if (configuration == null) {
                configuration = new ConfigurationBuilder().build();
            }
        } else {
            configuration = this.cacheManager.getCacheConfiguration(template);
            if (configuration == null) {
                throw log.undeclaredConfiguration(cacheName, template);
            }
        }
        return this.createCache(cacheName, template, configuration, flags);
    }

    Configuration createCache(String cacheName, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.localConfigurationManager.validateFlags(flags);
        try {
            CacheState state = new CacheState(template, this.parserRegistry.serialize(cacheName, configuration), flags);
            this.getStateCache().putIfAbsent(new ScopedState(CACHE_SCOPE, cacheName), state);
            return configuration;
        }
        catch (Exception e) {
            throw log.configurationSerializationFailed(cacheName, configuration, e);
        }
    }

    void createCacheLocally(String name, CacheState state) {
        log.debugf("Create cache %s", name);
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(state.getConfiguration());
        Configuration configuration = builderHolder.getNamedConfigurationBuilders().get(name).build();
        this.localConfigurationManager.createCache(name, configuration, state.getFlags());
    }

    @Override
    public void removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        ScopedState cacheScopedState = new ScopedState(CACHE_SCOPE, name);
        if (this.getStateCache().containsKey(cacheScopedState)) {
            this.getStateCache().remove(cacheScopedState);
        } else {
            this.localConfigurationManager.removeCache(name);
        }
    }

    void removeCacheLocally(String name, CacheState state) {
        this.localConfigurationManager.removeCache(name);
    }
}

