/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseStateTransferInterceptor
extends DDAsyncInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    private final InvocationFinallyFunction handleReadCommandReturn = this::handleReadCommandReturn;
    private StateTransferManager stateTransferManager;
    protected StateTransferLock stateTransferLock;
    private Executor remoteExecutor;
    private DistributionManager distributionManager;
    private ScheduledExecutorService timeoutExecutor;
    private long transactionDataTimeout;
    private final InvocationFinallyFunction handleLocalGetKeysInGroupReturn = this::handleLocalGetKeysInGroupReturn;

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration, StateTransferManager stateTransferManager, DistributionManager distributionManager, @ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, @ComponentName(value="org.infinispan.executors.remote") Executor remoteExecutor) {
        this.stateTransferLock = stateTransferLock;
        this.stateTransferManager = stateTransferManager;
        this.distributionManager = distributionManager;
        this.timeoutExecutor = timeoutExecutor;
        this.remoteExecutor = remoteExecutor;
        this.transactionDataTimeout = configuration.clustering().remoteTimeout();
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        this.updateTopologyId(command);
        if (ctx.isOriginLocal()) {
            return this.invokeNextAndHandle(ctx, command, this.handleLocalGetKeysInGroupReturn);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            GetKeysInGroupCommand cmd = (GetKeysInGroupCommand)rCommand;
            int commandTopologyId = cmd.getTopologyId();
            if (this.currentTopologyId() != commandTopologyId && this.distributionManager.getCacheTopology().isWriteOwner(cmd.getGroupName())) {
                throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + this.currentTopologyId());
            }
        });
    }

    private Object handleLocalGetKeysInGroupReturn(InvocationContext ctx, VisitableCommand command, Object rv, Throwable throwable) throws Throwable {
        boolean shouldRetry;
        GetKeysInGroupCommand cmd = (GetKeysInGroupCommand)command;
        int commandTopologyId = cmd.getTopologyId();
        if (throwable != null) {
            Throwable ce = throwable;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            shouldRetry = ce instanceof OutdatedTopologyException || ce instanceof SuspectException;
        } else {
            boolean bl = shouldRetry = this.currentTopologyId() != commandTopologyId && this.distributionManager.getCacheTopology().isWriteOwner(cmd.getGroupName());
        }
        if (shouldRetry) {
            this.logRetry(this.currentTopologyId(), cmd);
            int newTopologyId = Math.max(this.currentTopologyId(), commandTopologyId + 1);
            cmd.setTopologyId(newTopologyId);
            CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(newTopologyId);
            return this.retryWhenDone(transactionDataFuture, newTopologyId, ctx, command, this.handleLocalGetKeysInGroupReturn);
        }
        return BaseStateTransferInterceptor.valueOrException(rv, throwable);
    }

    protected final void logRetry(int currentTopologyId, TopologyAffectedCommand cmd) {
        if (this.trace) {
            this.getLog().tracef("Retrying command because of topology change, current topology is %d, command topology %d: %s", currentTopologyId, cmd.getTopologyId(), cmd);
        }
    }

    protected final int currentTopologyId() {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        return cacheTopology == null ? -1 : cacheTopology.getTopologyId();
    }

    protected final void updateTopologyId(TopologyAffectedCommand command) {
        if (command.getTopologyId() == -1) {
            int topologyId;
            CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
            int n = topologyId = cacheTopology == null ? 0 : cacheTopology.getTopologyId();
            if (this.trace) {
                this.getLog().tracef("Setting command topology to %d", topologyId);
            }
            command.setTopologyId(topologyId);
        }
    }

    protected <T extends VisitableCommand> Object retryWhenDone(CompletableFuture<Void> future, int topologyId, InvocationContext ctx, T command, InvocationFinallyFunction callback) {
        if (future.isDone()) {
            this.getLog().tracef("Retrying command %s for topology %d", command, topologyId);
            return this.invokeNextAndHandle(ctx, command, callback);
        }
        CancellableRetry<T> cancellableRetry = new CancellableRetry<T>(command, topologyId);
        CompletionStage retryFuture = future.handleAsync(cancellableRetry, this.remoteExecutor);
        cancellableRetry.setRetryFuture((CompletableFuture<Void>)retryFuture);
        ScheduledFuture<?> timeoutFuture = this.timeoutExecutor.schedule(cancellableRetry, this.transactionDataTimeout, TimeUnit.MILLISECONDS);
        cancellableRetry.setTimeoutFuture(timeoutFuture);
        return BaseStateTransferInterceptor.makeStage(this.asyncInvokeNext(ctx, command, retryFuture)).andHandle(ctx, command, callback);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    protected <C extends VisitableCommand & TopologyAffectedCommand> Object handleReadCommand(InvocationContext ctx, C command) {
        this.updateTopologyId(command);
        return this.invokeNextAndHandle(ctx, command, this.handleReadCommandReturn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object handleReadCommandReturn(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        int currentTopologyId;
        if (t == null) {
            return rv;
        }
        Throwable ce = t;
        while (ce instanceof RemoteException) {
            ce = ce.getCause();
        }
        TopologyAffectedCommand cmd = (TopologyAffectedCommand)((Object)rCommand);
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        int requestedTopologyId = currentTopologyId = cacheTopology == null ? -1 : cacheTopology.getTopologyId();
        if (ce instanceof SuspectException) {
            if (this.trace) {
                this.getLog().tracef("Retrying command because of suspected node, current topology is %d: %s", currentTopologyId, rCommand);
            }
            if (currentTopologyId == cmd.getTopologyId() && !cacheTopology.getActualMembers().contains(((SuspectException)((Object)ce)).getSuspect())) {
                throw new IllegalStateException("Command was not sent with SYNCHRONOUS_IGNORE_LEAVERS?");
            }
        } else if (ce instanceof OutdatedTopologyException) {
            this.logRetry(currentTopologyId, cmd);
            if (this.cacheConfiguration.clustering().cacheMode().isScattered()) {
                OutdatedTopologyException ote = (OutdatedTopologyException)((Object)ce);
                requestedTopologyId = ote.requestedTopologyId >= 0 ? Math.max(currentTopologyId, ote.requestedTopologyId) : Math.max(currentTopologyId, cmd.getTopologyId() + 1);
            }
        } else {
            if (!(ce instanceof AllOwnersLostException)) throw t;
            if (this.trace) {
                this.getLog().tracef("All owners for command %s have been lost.", cmd);
            }
            if (!this.cacheConfiguration.clustering().cacheMode().isScattered()) return rCommand.acceptVisitor(rCtx, LostDataVisitor.INSTANCE);
            requestedTopologyId = Math.max(currentTopologyId, cmd.getTopologyId() + 1);
        }
        cmd.setTopologyId(requestedTopologyId);
        ((FlagAffectedCommand)((Object)cmd)).addFlags(FlagBitSets.COMMAND_RETRY);
        if (requestedTopologyId != currentTopologyId) return BaseStateTransferInterceptor.makeStage(this.asyncInvokeNext(rCtx, rCommand, this.stateTransferLock.transactionDataFuture(requestedTopologyId))).andHandle(rCtx, rCommand, this.handleReadCommandReturn);
        return this.invokeNextAndHandle(rCtx, rCommand, this.handleReadCommandReturn);
    }

    protected int getNewTopologyId(Throwable ce, int currentTopologyId, TopologyAffectedCommand command) {
        int requestedTopologyId = command.getTopologyId() + 1;
        if (ce instanceof OutdatedTopologyException) {
            OutdatedTopologyException ote = (OutdatedTopologyException)((Object)ce);
            if (ote.requestedTopologyId >= 0) {
                requestedTopologyId = ote.requestedTopologyId;
            }
        }
        return Math.max(currentTopologyId, requestedTopologyId);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    protected abstract Log getLog();

    protected static class LostDataVisitor
    extends AbstractVisitor {
        public static final LostDataVisitor INSTANCE = new LostDataVisitor();

        protected LostDataVisitor() {
        }

        @Override
        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            return null;
        }

        @Override
        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
            return null;
        }

        @Override
        public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
            return command.performOnLostData();
        }
    }

    private static class CancellableRetry<T extends VisitableCommand>
    implements BiFunction<Void, Throwable, Void>,
    Runnable {
        private static final AtomicReferenceFieldUpdater<CancellableRetry, Throwable> cancellableRetryUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellableRetry.class, Throwable.class, "cancelled");
        private static final AtomicReferenceFieldUpdater<CancellableRetry, Object> timeoutFutureUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellableRetry.class, Object.class, "timeoutFuture");
        private static final Log log = LogFactory.getLog(CancellableRetry.class);
        private static final Throwable DUMMY = new Throwable("Command is retried");
        private final T command;
        private final int topologyId;
        private volatile Throwable cancelled = null;
        private CompletableFuture<Void> retryFuture;
        private volatile Object timeoutFuture;

        CancellableRetry(T command, int topologyId) {
            this.command = command;
            this.topologyId = topologyId;
        }

        @Override
        public Void apply(Void nil, Throwable throwable) {
            if (!timeoutFutureUpdater.compareAndSet(this, null, DUMMY)) {
                ((ScheduledFuture)this.timeoutFuture).cancel(false);
            }
            if (throwable != null) {
                throw CompletableFutures.asCompletionException(throwable);
            }
            if (!cancellableRetryUpdater.compareAndSet(this, null, DUMMY)) {
                log.tracef("Not retrying command %s as it has been cancelled.", this.command);
                throw CompletableFutures.asCompletionException(this.cancelled);
            }
            log.tracef("Retrying command %s for topology %d", this.command, this.topologyId);
            return null;
        }

        @Override
        public void run() {
            TimeoutException timeoutException = new TimeoutException("Timed out waiting for topology " + this.topologyId);
            if (cancellableRetryUpdater.compareAndSet(this, null, (Throwable)((Object)timeoutException))) {
                this.retryFuture.completeExceptionally((Throwable)((Object)timeoutException));
            }
        }

        void setRetryFuture(CompletableFuture<Void> retryFuture) {
            this.retryFuture = retryFuture;
        }

        void setTimeoutFuture(ScheduledFuture<?> timeoutFuture) {
            if (!timeoutFutureUpdater.compareAndSet(this, null, timeoutFuture)) {
                timeoutFuture.cancel(false);
            }
        }
    }
}

