/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.concurrent.CompletableFutures;

public class PrefetchInterceptor
extends DDAsyncInterceptor {
    protected static final Log log = LogFactory.getLog(PrefetchInterceptor.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected static final long STATE_TRANSFER_FLAGS = FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.SKIP_SHARED_CACHE_STORE | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.SKIP_XSITE_BACKUP;
    protected ScatteredVersionManager svm;
    protected StateTransferManager stm;
    protected DistributionManager dm;
    protected KeyPartitioner keyPartitioner;
    protected CommandsFactory commandsFactory;
    protected RpcManager rpcManager;
    protected Cache cache;
    protected int numSegments;
    private final InvocationSuccessFunction handleLocallyLookedUpEntry = this::handleLocallyLookedUpEntry;
    private final Function<Map<Address, Response>, InternalCacheValue> handleRemotelyPrefetchedEntry = this::handleRemotelyPrefetchedEntry;

    @Inject
    public void injectDependencies(ScatteredVersionManager svm, StateTransferManager stm, DistributionManager dm, KeyPartitioner keyPartitioner, CommandsFactory commandsFactory, RpcManager rpcManager, Cache cache) {
        this.svm = svm;
        this.stm = stm;
        this.dm = dm;
        this.keyPartitioner = keyPartitioner;
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.cache = cache;
    }

    @Start
    public void start() {
        this.numSegments = this.cacheConfiguration.clustering().hash().numSegments();
    }

    private boolean canRetrieveRemoteValue(FlagAffectedCommand command) {
        return !command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
    }

    protected Object handleReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntry(command.getKey());
        }
        if (this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeyIfNeededAndInvokeNext(ctx, command, command.getKey(), false);
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends VisitableCommand & TopologyAffectedCommand> Object prefetchKeyIfNeededAndInvokeNext(InvocationContext ctx, C command, Object key, boolean isWrite) {
        int segment = this.keyPartitioner.getSegment(key);
        switch (this.svm.getSegmentState(segment)) {
            case NOT_OWNED: {
                break;
            }
            case BLOCKED: {
                if (isWrite) {
                    return PrefetchInterceptor.asyncValue(this.svm.getBlockingFuture(segment)).thenApply(ctx, command, (rCtx, rCommand, ignored) -> this.prefetchKeyIfNeededAndInvokeNext(ctx, command, key, true));
                }
            }
            case KEY_TRANSFER: 
            case VALUE_TRANSFER: {
                return this.asyncInvokeNext(ctx, command, this.lookupLocalAndRetrieveRemote(ctx, key, ((TopologyAffectedCommand)command).getTopologyId()).toCompletableFuture());
            }
            case OWNED: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends VisitableCommand & TopologyAffectedCommand> Object prefetchKeysIfNeededAndInvokeNext(InvocationContext ctx, C command, Collection<?> keys, boolean isWrite) {
        BitSet blockedSegments = null;
        ArrayList transferedKeys = null;
        block6: for (Object key : keys) {
            int segment = this.keyPartitioner.getSegment(key);
            switch (this.svm.getSegmentState(segment)) {
                case NOT_OWNED: {
                    continue block6;
                }
                case BLOCKED: {
                    if (isWrite) {
                        if (blockedSegments == null) {
                            blockedSegments = new BitSet(this.numSegments);
                        }
                        blockedSegments.set(segment);
                    }
                }
                case KEY_TRANSFER: 
                case VALUE_TRANSFER: {
                    if (transferedKeys == null) {
                        transferedKeys = new ArrayList(keys.size());
                    }
                    transferedKeys.add(key);
                }
                case OWNED: {
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        if (blockedSegments != null) {
            CompletableFuture<Void> blockingFuture = CompletableFuture.allOf((CompletableFuture[])blockedSegments.stream().mapToObj(this.svm::getBlockingFuture).toArray(CompletableFuture[]::new));
            return PrefetchInterceptor.asyncValue(blockingFuture.thenCompose(nil -> PrefetchInterceptor.makeStage(this.prefetchKeysIfNeededAndInvokeNext(ctx, command, keys, true)).toCompletableFuture()));
        }
        if (transferedKeys != null) {
            return this.asyncInvokeNext(ctx, command, this.retrieveRemoteValues(ctx, transferedKeys, ((TopologyAffectedCommand)command).getTopologyId()).toCompletableFuture());
        }
        return this.invokeNext(ctx, command);
    }

    private InvocationStage lookupLocalAndRetrieveRemote(InvocationContext ctx, Object key, int topologyId) {
        if (trace) {
            log.tracef("Locally prefetching entry for key %s", key);
        }
        GetCacheEntryCommand getCacheEntryCommand = this.commandsFactory.buildGetCacheEntryCommand(key, EnumUtil.bitSetOf((Enum)Flag.CACHE_MODE_LOCAL));
        getCacheEntryCommand.setTopologyId(topologyId);
        return PrefetchInterceptor.makeStage(this.invokeNextThenApply(ctx, getCacheEntryCommand, this.handleLocallyLookedUpEntry));
    }

    private Object handleLocallyLookedUpEntry(InvocationContext ctx1, VisitableCommand command1, Object rv) {
        CompletionStage<InternalCacheValue> future;
        CacheEntry entry;
        GetCacheEntryCommand cmd = (GetCacheEntryCommand)command1;
        if (trace) {
            log.tracef("Locally prefetched entry %s", rv);
        }
        Metadata metadata = (entry = (CacheEntry)rv) != null ? entry.getMetadata() : null;
        int segment = this.keyPartitioner.getSegment(cmd.getKey());
        if (metadata != null && metadata.version() != null && this.svm.isVersionActual(segment, metadata.version())) {
            return null;
        }
        if (metadata instanceof RemoteMetadata && this.svm.getSegmentState(segment) == ScatteredVersionManager.SegmentState.VALUE_TRANSFER) {
            Address backup = ((RemoteMetadata)metadata).getAddress();
            future = this.retrieveRemoteValue(Collections.singleton(backup), cmd.getKey(), cmd.getTopologyId());
        } else {
            future = this.retrieveRemoteValue(null, cmd.getKey(), cmd.getTopologyId());
        }
        return PrefetchInterceptor.asyncValue(future.thenAccept(maxValue -> {
            if (maxValue == null) {
                return;
            }
            PutKeyValueCommand putKeyValueCommand = this.commandsFactory.buildPutKeyValueCommand(cmd.getKey(), maxValue.getValue(), maxValue.getMetadata(), STATE_TRANSFER_FLAGS);
            putKeyValueCommand.setTopologyId(cmd.getTopologyId());
            this.invokeNext(ctx1, putKeyValueCommand);
        }));
    }

    private CompletionStage<InternalCacheValue> retrieveRemoteValue(Collection<Address> targets, Object key, int topologyId) {
        if (trace) {
            log.tracef("Prefetching entry for key %s from %s", key, targets);
        }
        ClusteredGetCommand command = this.commandsFactory.buildClusteredGetCommand(key, FlagBitSets.SKIP_OWNERSHIP_CHECK);
        command.setTopologyId(topologyId);
        CompletionStage<Map<Address, Response>> remoteInvocation = targets != null ? this.rpcManager.invokeCommand(targets, (ReplicableCommand)command, MapResponseCollector.ignoreLeavers(targets.size()), this.rpcManager.getSyncRpcOptions()) : this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        return remoteInvocation.thenApply(this.handleRemotelyPrefetchedEntry);
    }

    private InternalCacheValue handleRemotelyPrefetchedEntry(Map<Address, Response> responseMap) {
        EntryVersion maxVersion = null;
        InternalCacheValue maxValue = null;
        for (Response response : responseMap.values()) {
            if (!response.isSuccessful()) {
                throw OutdatedTopologyException.INSTANCE;
            }
            SuccessfulResponse successfulResponse = (SuccessfulResponse)response;
            InternalCacheValue icv = (InternalCacheValue)successfulResponse.getResponseValue();
            if (icv == null) continue;
            Metadata metadata = icv.getMetadata();
            if (metadata instanceof RemoteMetadata) {
                throw OutdatedTopologyException.INSTANCE;
            }
            if (metadata == null || metadata.version() == null || maxVersion != null && maxVersion.compareTo(metadata.version()) != InequalVersionComparisonResult.BEFORE) continue;
            maxVersion = metadata.version();
            maxValue = icv;
        }
        if (trace) {
            log.tracef("Prefetched value is %s", maxValue);
        }
        return maxValue;
    }

    private InvocationStage retrieveRemoteValues(InvocationContext ctx, List<?> keys, int topologyId) {
        if (trace) {
            log.tracef("Prefetching entries for keys %s using broadcast", keys);
        }
        ClusteredGetAllCommand command = this.commandsFactory.buildClusteredGetAllCommand(keys, FlagBitSets.SKIP_OWNERSHIP_CHECK, null);
        command.setTopologyId(topologyId);
        return PrefetchInterceptor.asyncValue(this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions()).thenCompose(responseMap -> {
            InternalCacheValue[] maxValues = new InternalCacheValue[keys.size()];
            for (Response response : responseMap.values()) {
                if (!response.isSuccessful()) {
                    throw OutdatedTopologyException.INSTANCE;
                }
                InternalCacheValue[] values = (InternalCacheValue[])((SuccessfulResponse)response).getResponseValue();
                int i = 0;
                for (InternalCacheValue icv : values) {
                    if (icv != null) {
                        Metadata maxMetadata;
                        Metadata metadata = icv.getMetadata();
                        if (metadata instanceof RemoteMetadata) {
                            throw OutdatedTopologyException.INSTANCE;
                        }
                        if (maxValues[i] == null) {
                            maxValues[i] = icv;
                        } else if (metadata != null && metadata.version() != null && ((maxMetadata = maxValues[i].getMetadata()) == null || maxMetadata.version() == null || maxMetadata.version().compareTo(metadata.version()) == InequalVersionComparisonResult.BEFORE)) {
                            maxValues[i] = icv;
                        }
                    }
                    ++i;
                }
            }
            HashMap map = new HashMap(keys.size());
            for (int i = 0; i < maxValues.length; ++i) {
                if (maxValues[i] == null) continue;
                map.put(keys.get(i), maxValues[i]);
            }
            if (trace) {
                log.tracef("Prefetched values are %s", map);
            }
            if (map.isEmpty()) {
                return CompletableFutures.completedNull();
            }
            PutMapCommand putMapCommand = this.commandsFactory.buildPutMapCommand(map, null, STATE_TRANSFER_FLAGS);
            putMapCommand.setTopologyId(topologyId);
            return PrefetchInterceptor.makeStage(this.invokeNext(ctx, putMapCommand)).toCompletableFuture();
        }));
    }

    protected Object handleReadManyCommand(InvocationContext ctx, AbstractTopologyAffectedCommand command, Collection<?> keys) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntries(keys);
        }
        if (this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeysIfNeededAndInvokeNext(ctx, command, keys, false);
        }
        return this.invokeNext(ctx, command);
    }

    protected Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntry(command.getKey());
        }
        if (command.loadType() != VisitableCommand.LoadType.DONT_LOAD && this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeyIfNeededAndInvokeNext(ctx, command, command.getKey(), true);
        }
        return this.invokeNext(ctx, command);
    }

    protected Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntries(command.getAffectedKeys());
        }
        if (command.loadType() != VisitableCommand.LoadType.DONT_LOAD && this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeysIfNeededAndInvokeNext(ctx, command, command.getAffectedKeys(), true);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    public AdvancedCache getCacheWithFlags(FlagAffectedCommand command) {
        Set<Flag> flags = command.getFlags();
        return this.cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()]));
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            boolean ignoreOwnership = command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
            return new BackingKeySet(this.getCacheWithFlags(command), ignoreOwnership, (Set)rv);
        });
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            boolean ignoreOwnership = command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
            return new BackingEntrySet(this.getCacheWithFlags(command), ignoreOwnership, (Set)rv);
        });
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        if (command.isGroupOwner()) {
            int segment = this.keyPartitioner.getSegment(command.getGroupName());
            switch (this.svm.getSegmentState(segment)) {
                case NOT_OWNED: {
                    break;
                }
                case BLOCKED: 
                case KEY_TRANSFER: 
                case VALUE_TRANSFER: {
                    return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.svm.valuesFuture(command.getTopologyId()));
                }
                case OWNED: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    private class BackingKeySet<K, V>
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CacheSet<K> {
        private final Set<K> keySet;
        private final boolean ignoreOwnership;

        public BackingKeySet(Cache<K, V> cache, boolean ignoreOwnership, Set<K> keySet) {
            super(cache);
            this.ignoreOwnership = ignoreOwnership;
            this.keySet = keySet;
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new CloseableIterator<K>(){
                BackingIterator<K, K, V> iterator;
                {
                    this.iterator = new BackingIterator(BackingKeySet.this.cache, BackingKeySet.this.ignoreOwnership, () -> BackingKeySet.this.keySet.iterator(), Function.identity());
                }

                public void close() {
                    this.iterator.close();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public K next() {
                    return this.iterator.next();
                }
            };
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        @Override
        public CacheStream<K> stream() {
            return new LocalCacheStream(new KeyStreamSupplier(this.cache, PrefetchInterceptor.this.dm.getCacheTopology()::getSegment, () -> StreamSupport.stream(this.spliterator(), false)), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<K> parallelStream() {
            return new LocalCacheStream(new KeyStreamSupplier(this.cache, PrefetchInterceptor.this.dm.getCacheTopology()::getSegment, () -> StreamSupport.stream(this.spliterator(), false)), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }

    private class BackingIterator<O, K, V>
    implements CloseableIterator<O> {
        private final Cache<K, V> cache;
        private final Supplier<Iterator<O>> supplier;
        private final Function<O, K> keyRetrieval;
        private final boolean ignoreOwnership;
        private Iterator<O> iterator;
        private K previousKey;
        private O next;
        private List<Integer> blockedSegments;
        private int lastTopology;
        private boolean[] finishedSegments;

        public void remove() {
            if (this.previousKey == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.previousKey);
            this.previousKey = null;
        }

        public BackingIterator(Cache<K, V> cache, boolean ignoreOwnership, Supplier<Iterator<O>> supplier, Function<O, K> keyRetrieval) {
            this.cache = cache;
            this.ignoreOwnership = ignoreOwnership;
            this.supplier = supplier;
            log.tracef("Retrieving iterator for %s for the first time", cache);
            this.iterator = supplier.get();
            this.keyRetrieval = keyRetrieval;
            this.findNotReadySegments();
        }

        protected void findNotReadySegments() {
            if (this.ignoreOwnership) {
                return;
            }
            do {
                this.lastTopology = PrefetchInterceptor.this.stm.getCacheTopology().getTopologyId();
                int numSegments = this.cache.getCacheConfiguration().clustering().hash().numSegments();
                if (this.blockedSegments != null) {
                    this.blockedSegments.clear();
                }
                block5: for (int segment = 0; segment < numSegments; ++segment) {
                    switch (PrefetchInterceptor.this.svm.getSegmentState(segment)) {
                        case NOT_OWNED: {
                            continue block5;
                        }
                        case BLOCKED: 
                        case KEY_TRANSFER: 
                        case VALUE_TRANSFER: {
                            this.addBlocked(segment);
                            continue block5;
                        }
                    }
                }
            } while (PrefetchInterceptor.this.stm.getCacheTopology().getTopologyId() != this.lastTopology);
        }

        private void addBlocked(int segment) {
            if (this.blockedSegments == null) {
                this.blockedSegments = new ArrayList<Integer>();
            }
            this.blockedSegments.add(segment);
        }

        public boolean hasNext() {
            if (this.iterator == null) {
                this.next = null;
                return false;
            }
            while (true) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (this.ignoreOwnership) {
                        return true;
                    }
                    int segment = PrefetchInterceptor.this.keyPartitioner.getSegment(this.keyRetrieval.apply(this.next));
                    if (this.finishedSegments != null && this.finishedSegments[segment] || PrefetchInterceptor.this.svm.getSegmentState(segment) != ScatteredVersionManager.SegmentState.OWNED) continue;
                    return true;
                }
                if (this.blockedSegments == null || this.blockedSegments.isEmpty()) break;
                if (this.lastTopology == PrefetchInterceptor.this.stm.getCacheTopology().getTopologyId()) {
                    int numSegments = this.cache.getCacheConfiguration().clustering().hash().numSegments();
                    boolean[] newFinishedSegments = this.finishedSegments == null ? new boolean[numSegments] : Arrays.copyOf(this.finishedSegments, numSegments);
                    for (int segment = 0; segment < numSegments; ++segment) {
                        if (PrefetchInterceptor.this.svm.getSegmentState(segment) != ScatteredVersionManager.SegmentState.OWNED) continue;
                        newFinishedSegments[segment] = true;
                    }
                    if (this.lastTopology == PrefetchInterceptor.this.stm.getCacheTopology().getTopologyId()) {
                        this.finishedSegments = newFinishedSegments;
                    }
                }
                try {
                    PrefetchInterceptor.this.svm.valuesFuture(this.lastTopology).get(PrefetchInterceptor.this.cacheConfiguration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                this.findNotReadySegments();
                if (this.iterator instanceof CloseableIterator) {
                    ((CloseableIterator)this.iterator).close();
                }
                log.tracef("Retrieving iterator for %s in topology %d, blocked segments are %s", this.cache, (Object)this.lastTopology, this.blockedSegments);
                this.iterator = this.supplier.get();
            }
            return false;
        }

        public O next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != null);
            this.previousKey = this.keyRetrieval.apply(this.next);
            return this.next;
        }

        public void close() {
            if (this.iterator instanceof CloseableIterator) {
                ((CloseableIterator)this.iterator).close();
            }
            this.iterator = null;
        }
    }

    private class BackingEntrySet<K, V>
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        private final Set<CacheEntry<K, V>> entrySet;
        private final boolean ignoreOwnership;

        public BackingEntrySet(Cache<K, V> cache, boolean ignoreOwnership, Set<CacheEntry<K, V>> entrySet) {
            super(cache);
            this.ignoreOwnership = ignoreOwnership;
            this.entrySet = entrySet;
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new BackingIterator(this.cache, this.ignoreOwnership, () -> this.entrySet.stream().iterator(), entry -> entry.getKey());
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Object v = this.cache.get(((Map.Entry)o).getKey());
                return Objects.equals(v, ((Map.Entry)o).getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                return this.cache.remove(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
            }
            return false;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, PrefetchInterceptor.this.dm.getCacheTopology()::getSegment, () -> super.stream()), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, PrefetchInterceptor.this.dm.getCacheTopology()::getSegment, () -> super.stream()), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

