/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.function.Predicate;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTransactionalLockingInterceptor
extends AbstractLockingInterceptor {
    private static final Log log = LogFactory.getLog(NonTransactionalLockingInterceptor.class);
    private final Predicate<Object> shouldLockKey = this::shouldLockKey;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        return this.visitNonTxDataWriteCommand(ctx, command);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) {
        this.assertNonTransactional(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command, Collection<K> keys, boolean forwarded) throws Throwable {
        this.assertNonTransactional(ctx);
        if (forwarded || this.hasSkipLocking(command)) {
            return this.invokeNext(ctx, command);
        }
        try {
            this.lockAllAndRecord(ctx, keys.stream().filter(this.shouldLockKey), this.getLockTimeoutMillis(command));
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    private void assertNonTransactional(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            throw new InvalidCacheUsageException("This is a non-transactional cache and cannot be accessed with a transactional InvocationContext.");
        }
    }
}

