/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.commons.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.commons.marshall.jboss.SerializeWithExtFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    final GlobalConfiguration globalCfg;
    final GlobalMarshaller marshaller;

    public JBossMarshaller() {
        this.globalCfg = null;
        this.marshaller = null;
    }

    public JBossMarshaller(GlobalMarshaller marshaller, GlobalConfiguration globalCfg) {
        this.globalCfg = globalCfg;
        this.marshaller = marshaller;
    }

    public void start() {
        super.start();
        this.baseCfg.setClassExternalizerFactory((ClassExternalizerFactory)new SerializeWithExtFactory());
        this.baseCfg.setObjectTable(new ObjectTable(){

            public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
                BiConsumer<ObjectOutput, Object> writer = JBossMarshaller.this.marshaller.findWriter(object);
                return writer != null ? writer::accept : null;
            }

            public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
                AdvancedExternalizer ext = JBossMarshaller.this.marshaller.findExternalizerIn((ObjectInput)unmarshaller);
                return ext.readObject((ObjectInput)unmarshaller);
            }
        });
        ClassResolver classResolver = this.globalCfg.serialization().classResolver();
        if (classResolver == null) {
            ClassLoader cl = this.globalCfg.classLoader();
            classResolver = new DefaultContextClassResolver(cl);
        }
        this.baseCfg.setClassResolver(classResolver);
    }

    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
    }

    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || o.getClass().getAnnotation(SerializeWith.class) != null || o.getClass().getAnnotation(Externalize.class) != null;
    }
}

